## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ordinalTables)

## ----mental_health------------------------------------------------------------
mental_health

## ----null_model---------------------------------------------------------------
null_model <- Goodman_null_association(mental_health)

## ----uniform_association------------------------------------------------------
uniform_model <- Goodman_uniform_association(mental_health)

## ----r_c_association----------------------------------------------------------
rows <- Goodman_model_i(mental_health, row_effects = TRUE, column_effects = FALSE)
columns <- Goodman_model_i(mental_health, row_effects=FALSE, column_effects=TRUE)

## ----rc_association-----------------------------------------------------------
rc_association <- Goodman_model_i(mental_health)

## ----model_ii_full------------------------------------------------------------
model_ii_result <- Goodman_model_ii(mental_health)

## ----model_ii_fixed_rows------------------------------------------------------
rho = c(0.2, 0.0, 0.0, -0.2)
result_rows <- Goodman_model_ii(mental_health, rho=rho, update_rows=FALSE)

## ----ignore_diagonal----------------------------------------------------------
null_result <- Goodman_null_association(social_status, exclude_diagonal=TRUE, verbose=FALSE, max_iter=15)
uniform_result <- Goodman_uniform_association(social_status, exclude_diagonal=TRUE, verbose=FALSE, max_iter=15)
row_result <- Goodman_model_i(social_status, row_effects=TRUE, column_effects =FALSE, exclude_diagonal=TRUE, verbose=FALSE, max_iter=15)
column_result <- Goodman_model_i(social_status, row_effects=FALSE, column_effects=TRUE, exclude_diagonal=TRUE, verbose=FALSE, max_iter=15)
rc_result <- Goodman_model_i(social_status, row_effects=TRUE, column_effects=TRUE, exclude_diagonal=TRUE, verbose=FALSE, max_iter=15)
model_ii_result <- Goodman_model_ii(social_status, update_rows=TRUE, update_columns =FALSE, exclude_diagonal=TRUE, verbose=FALSE, max_iter =15)

