/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.syntaxtree.SyntaxTree;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxTreeIndividual
extends AbstractIndividual<SyntaxTree[]> {
    protected static final XmlFormat<SyntaxTreeIndividual> SYNTAX_TREE_INDIVIDUAL_XML = new XmlFormat<SyntaxTreeIndividual>(SyntaxTreeIndividual.class){

        @Override
        public void format(SyntaxTreeIndividual source, XmlElement xml) {
            SyntaxTreeIndividual.access$0().format(source, xml);
            xml.add(source.genotype, "genotype", GENOTYPE_XML);
        }

        @Override
        public SyntaxTreeIndividual parse(XmlElement xml) {
            SyntaxTreeIndividual result = (SyntaxTreeIndividual)SyntaxTreeIndividual.access$0().parse(xml);
            result.genotype = (SyntaxTree[])xml.get("genotype", GENOTYPE_XML);
            return result;
        }

        @Override
        public String defaultName() {
            return "syntax-tree-individual";
        }
    };
    protected static final XmlFormat<SyntaxTree[]> GENOTYPE_XML = new XmlFormat<SyntaxTree[]>(SyntaxTree[].class){

        @Override
        public void format(SyntaxTree[] source, XmlElement xml) {
            int numberOfSyntaxTrees = source.length;
            xml.setAttribute("number-of-syntax-trees", numberOfSyntaxTrees);
            int i = 0;
            while (i < numberOfSyntaxTrees) {
                xml.add(source[i], "syntax-tree", SyntaxTree.SYNTAX_TREE_XML);
                ++i;
            }
        }

        @Override
        public SyntaxTree[] parse(XmlElement xml) {
            int numberOfSyntaxTrees = xml.getAttribute("number-of-syntax-trees", 0);
            SyntaxTree[] result = new SyntaxTree[numberOfSyntaxTrees];
            int i = 0;
            while (i < numberOfSyntaxTrees) {
                result[i] = (SyntaxTree)xml.get("syntax-tree", SyntaxTree.SYNTAX_TREE_XML);
                ++i;
            }
            return result;
        }
    };
    private static final long serialVersionUID = -2339079985634157433L;

    public SyntaxTreeIndividual() {
    }

    public SyntaxTreeIndividual(SyntaxTree[] genotype) {
        super(genotype);
    }

    public SyntaxTreeIndividual(SyntaxTree[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public double distance(IIndividual other) {
        return 0.0;
    }

    @Override
    public IIndividual copy() {
        int gl = ((SyntaxTree[])this.genotype).length;
        SyntaxTree[] genotypeCopy = new SyntaxTree[gl];
        int i = 0;
        while (i < gl) {
            genotypeCopy[i] = ((SyntaxTree[])this.genotype)[i].copy();
            ++i;
        }
        return new SyntaxTreeIndividual(genotypeCopy);
    }

    public boolean equals(Object other) {
        if (other instanceof SyntaxTreeIndividual) {
            SyntaxTreeIndividual cother = (SyntaxTreeIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object[])this.genotype, (Object[])cother.genotype);
            return eb.isEquals();
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("genotype", (Object[])this.genotype);
        tsb.append("fitness", this.fitness);
        return tsb.toString();
    }

    static /* synthetic */ XmlFormat access$0() {
        return AbstractIndividual.XML;
    }
}

