/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.PSO_ACO;

import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Atributo;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Condicion;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Muestra;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Regla;

public class ConjuntoDatos {
    private Vector muestras;

    public ConjuntoDatos() {
        this.muestras = new Vector();
    }

    public ConjuntoDatos(Vector datos) {
        this.muestras = new Vector(datos);
    }

    public void insertaMuestra(Muestra ejemplo) {
        this.muestras.addElement(ejemplo);
    }

    public void eliminaMuestra(int indice) {
        this.muestras.removeElementAt(indice);
    }

    public boolean eliminaMuestra(Muestra muestra) {
        boolean devolver = this.muestras.remove(muestra);
        return devolver;
    }

    public Muestra obtenerMuestra() {
        Muestra devolver = (Muestra)this.muestras.firstElement();
        return devolver;
    }

    public Muestra obtenerMuestra(int indice) {
        Muestra devolver = (Muestra)this.muestras.get(indice);
        return devolver;
    }

    public void imprimir(String nombre) {
        System.out.println("Conjunto de muestras " + nombre);
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra actual = (Muestra)this.muestras.get(i);
            actual.imprimir();
        }
    }

    public int tamanio() {
        int devolver = this.muestras.size();
        return devolver;
    }

    public float[] listaProbabilidadesAtributoClase(Atributo atributo, Vector clases) {
        int i;
        int numClases = clases.size();
        float[] devolver = new float[numClases];
        int total = 0;
        boolean terminado = false;
        for (i = 0; i < numClases; ++i) {
            devolver[i] = 0.0f;
        }
        for (i = 0; i < this.muestras.size(); ++i) {
            Muestra actual = (Muestra)this.muestras.get(i);
            if (!actual.estaAtributo(atributo)) continue;
            ++total;
            terminado = false;
            for (int j = 0; j < numClases && !terminado; ++j) {
                Atributo clase = (Atributo)clases.get(j);
                if (!actual.estaClase(clase)) continue;
                int n = j;
                devolver[n] = devolver[n] + 1.0f;
                terminado = true;
            }
        }
        for (i = 0; i < numClases; ++i) {
            if (devolver[i] == 0.0f) continue;
            devolver[i] = devolver[i] / (float)total;
        }
        return devolver;
    }

    public void eliminaMuestrasCubiertas(Regla regla) {
        Vector<Muestra> lista = new Vector<Muestra>();
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            if (!regla.estanCondicionesEn(mt)) continue;
            lista.addElement(mt);
        }
        this.muestras.removeAll(lista);
    }

    public void eliminaMuestrasClase(Regla regla) {
        Vector<Muestra> lista = new Vector<Muestra>();
        Atributo clase = regla.obtenerReglaPredicha();
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            if (!mt.estaClase(clase)) continue;
            lista.addElement(mt);
        }
        this.muestras.removeAll(lista);
    }

    public float porcentajeMuestrasCubiertas(Regla regla, Vector cVacias) {
        float porcentaje = 0.0f;
        float total = this.muestras.size();
        float cubiertas = 0.0f;
        Vector<Muestra> eliminar = new Vector<Muestra>();
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            if (!regla.cubreMuestraTotal(mt)) continue;
            cubiertas += 1.0f;
            eliminar.addElement(mt);
        }
        this.muestras.removeAll(eliminar);
        porcentaje = cubiertas;
        return porcentaje;
    }

    public Vector obtenerMuestras() {
        Vector devolver = new Vector(this.muestras);
        return devolver;
    }

    public int obtenerMayorClase(Vector listaClases) {
        int i;
        int[] ocurrencias = new int[listaClases.size()];
        int mejor = 0;
        int posMejor = 0;
        for (i = 0; i < listaClases.size(); ++i) {
            ocurrencias[i] = 0;
        }
        for (i = 0; i < this.muestras.size(); ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            Atributo clase = mt.getClase();
            for (int j = 0; j < listaClases.size(); ++j) {
                Atributo original = (Atributo)listaClases.get(j);
                if (!clase.esIgual(original)) continue;
                int n = j;
                ocurrencias[n] = ocurrencias[n] + 1;
            }
        }
        for (i = 0; i < listaClases.size(); ++i) {
            if (ocurrencias[i] < mejor) continue;
            mejor = ocurrencias[i];
            posMejor = i;
        }
        return posMejor;
    }

    public float porcentajeMuestrasCondicion(Condicion condicion, Atributo clase) {
        float tamanio = 0.0f;
        float aciertos = 0.0f;
        Atributo at = condicion.getValor();
        int indice = at.getAtributo();
        block5: for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            Atributo comprobar = mt.getValor(indice);
            if (at.getValor() == -1.0f || comprobar.getValor() == -1.0f) {
                tamanio += 1.0f;
                continue;
            }
            switch (condicion.getOperador()) {
                case 0: {
                    if (!comprobar.esIgual(at)) continue block5;
                    tamanio += 1.0f;
                    if (!mt.getClase().esIgual(clase)) continue block5;
                    aciertos += 1.0f;
                    continue block5;
                }
                case 1: {
                    double valorOriginal = comprobar.getValor();
                    double valorCondicion = at.getValor();
                    if (!(valorOriginal <= valorCondicion)) continue block5;
                    tamanio += 1.0f;
                    if (!mt.getClase().esIgual(clase)) continue block5;
                    aciertos += 1.0f;
                    continue block5;
                }
                case 2: {
                    double valorOriginal = comprobar.getValor();
                    double valorCondicion = at.getValor();
                    if (!(valorOriginal >= valorCondicion)) continue block5;
                    tamanio += 1.0f;
                    if (!mt.getClase().esIgual(clase)) continue block5;
                    aciertos += 1.0f;
                }
            }
        }
        float porcentaje = aciertos == 0.0f ? 0.0f : aciertos / tamanio;
        return porcentaje;
    }

    public float porcentajeMuestrasVacias(Atributo vacio, Atributo clase) {
        float aciertos = 0.0f;
        float tamanio = 0.0f;
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            if (mt.estaAtributo(vacio) && mt.estaClase(clase)) {
                aciertos += 1.0f;
            }
            if (!mt.estaAtributo(vacio)) continue;
            tamanio += 1.0f;
        }
        float porcentaje = aciertos == 0.0f || tamanio == 0.0f ? 0.0f : aciertos / tamanio;
        return porcentaje;
    }

    public float porcentajeMuestrasClase(Atributo clase) {
        int tamanio = this.muestras.size();
        float aciertos = 0.0f;
        for (int i = 0; i < tamanio; ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            if (!mt.estaClase(clase)) continue;
            aciertos += 1.0f;
        }
        return aciertos / (float)tamanio;
    }

    public int[] porcentajeMuestrasClase(Vector clases) {
        int i;
        int tamanio = this.muestras.size();
        boolean parada = false;
        int[] aciertos = new int[clases.size()];
        for (i = 0; i < clases.size(); ++i) {
            aciertos[i] = 0;
        }
        for (i = 0; i < tamanio; ++i) {
            Muestra mt = (Muestra)this.muestras.get(i);
            parada = false;
            for (int j = 0; j < clases.size() && !parada; ++j) {
                Atributo clase = (Atributo)clases.get(j);
                if (!mt.estaClase(clase)) continue;
                int n = j;
                aciertos[n] = aciertos[n] + 1;
                parada = true;
            }
        }
        return aciertos;
    }

    public int numeroMuestrasCondiciones(Regla hormiga, Vector cVacias) {
        int devolver = 0;
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra actual = (Muestra)this.muestras.get(i);
            if (!hormiga.cubreMuestraTotal(actual)) continue;
            ++devolver;
        }
        return devolver;
    }

    public int numeroMuestrasCubiertas(Regla hormiga, Vector cVacias) {
        int devolver = 0;
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra actual = (Muestra)this.muestras.get(i);
            if (!hormiga.cubreMuestraTotal(actual)) continue;
            ++devolver;
        }
        return devolver;
    }

    public int numeroMuestrasCubiertasSinClase(Regla hormiga) {
        int devolver = 0;
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra actual = (Muestra)this.muestras.get(i);
            if (!hormiga.estanCondicionesEn(actual)) continue;
            ++devolver;
        }
        return devolver;
    }

    public boolean cubreMinimo(Regla hormiga, int minimoCasosRegla) {
        int cubiertas = 0;
        for (int i = 0; i < this.muestras.size(); ++i) {
            Muestra actual = (Muestra)this.muestras.get(i);
            if (hormiga.cubreMuestraTotal(actual)) {
                ++cubiertas;
            }
            if (cubiertas < minimoCasosRegla) continue;
            return true;
        }
        return false;
    }
}

