/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes.Genotype;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import org.core.Randomize;

public class GenotypePitts
extends Genotype {
    private int[] involvedRuleAllele;
    private double[] ruleWeightAllele;
    private int numberOfConsequents;

    public GenotypePitts(int n, int nlabels, Randomize r) {
        super(r);
        this.numberOfConsequents = nlabels;
        this.ruleWeightAllele = new double[n];
        this.involvedRuleAllele = new int[n];
    }

    public GenotypePitts(GenotypePitts p) {
        super(rand);
        int i;
        this.involvedRuleAllele = new int[p.involvedRuleAllele.length];
        for (i = 0; i < this.involvedRuleAllele.length; ++i) {
            this.involvedRuleAllele[i] = p.involvedRuleAllele[i];
        }
        this.ruleWeightAllele = new double[p.ruleWeightAllele.length];
        for (i = 0; i < this.ruleWeightAllele.length; ++i) {
            this.ruleWeightAllele[i] = p.ruleWeightAllele[i];
        }
        this.numberOfConsequents = p.numberOfConsequents;
    }

    public void set(GenotypePitts p) {
        int i;
        this.involvedRuleAllele = new int[p.involvedRuleAllele.length];
        for (i = 0; i < this.involvedRuleAllele.length; ++i) {
            this.involvedRuleAllele[i] = p.involvedRuleAllele[i];
        }
        this.ruleWeightAllele = new double[p.ruleWeightAllele.length];
        for (i = 0; i < this.ruleWeightAllele.length; ++i) {
            this.ruleWeightAllele[i] = p.ruleWeightAllele[i];
        }
        this.numberOfConsequents = p.numberOfConsequents;
    }

    @Override
    public Genotype clone() {
        return new GenotypePitts(this);
    }

    @Override
    public boolean isRelated(Genotype p) {
        return p instanceof GenotypePitts;
    }

    @Override
    public void Random() {
        int i;
        for (i = 0; i < this.ruleWeightAllele.length; ++i) {
            this.ruleWeightAllele[i] = rand.Rand();
        }
        for (i = 0; i < this.involvedRuleAllele.length; ++i) {
            this.involvedRuleAllele[i] = (int)((double)this.numberOfConsequents * rand.Rand());
        }
    }

    @Override
    public void crossover(Genotype padre2, Genotype offspng1, Genotype offspng2, int crossoverID) throws invalidCrossover {
        if (crossoverID != 1) {
            throw new invalidCrossover();
        }
        GenotypePitts p2 = (GenotypePitts)padre2;
        GenotypePitts of1 = (GenotypePitts)offspng1;
        GenotypePitts of2 = (GenotypePitts)offspng2;
        double alpha = 1.5 * (rand.Rand() - 0.5);
        for (int i = 0; i < this.ruleWeightAllele.length; ++i) {
            double val1 = this.ruleWeightAllele[i] + alpha * (p2.ruleWeightAllele[i] - this.ruleWeightAllele[i]);
            if (val1 < 0.0) {
                val1 = 0.0;
            }
            if (val1 > 1.0) {
                val1 = 1.0;
            }
            of1.ruleWeightAllele[i] = val1;
            double val2 = p2.ruleWeightAllele[i] + alpha * (this.ruleWeightAllele[i] - p2.ruleWeightAllele[i]);
            if (val2 < 0.0) {
                val2 = 0.0;
            }
            if (val2 > 1.0) {
                val2 = 1.0;
            }
            of2.ruleWeightAllele[i] = val2;
        }
        int pos1 = (int)(rand.Rand() * (double)this.involvedRuleAllele.length);
        int pos2 = (int)(rand.Rand() * (double)this.involvedRuleAllele.length);
        if (pos2 < pos1) {
            int tmp = pos2;
            pos2 = pos1;
            pos1 = tmp;
        }
        for (int i = 0; i < this.involvedRuleAllele.length; ++i) {
            if (i >= pos1 && i <= pos2) {
                of2.involvedRuleAllele[i] = this.involvedRuleAllele[i];
                of1.involvedRuleAllele[i] = p2.involvedRuleAllele[i];
                continue;
            }
            of1.involvedRuleAllele[i] = this.involvedRuleAllele[i];
            of2.involvedRuleAllele[i] = p2.involvedRuleAllele[i];
        }
    }

    @Override
    public void mutation(double alpha, int mutationID) throws invalidMutation {
        if (mutationID != 2) {
            throw new invalidMutation();
        }
        GenotypePitts randomGenotype = new GenotypePitts(this.ruleWeightAllele.length, this.numberOfConsequents, rand);
        randomGenotype.Random();
        for (int i = 0; i < this.ruleWeightAllele.length; ++i) {
            double val = this.ruleWeightAllele[i] + alpha * (randomGenotype.ruleWeightAllele[i] - this.ruleWeightAllele[i]);
            if (val < 0.0) {
                val = 0.0;
            }
            if (val > 1.0) {
                val = 1.0;
            }
            this.ruleWeightAllele[i] = val;
        }
        int pos = (int)(rand.Rand() * (double)this.involvedRuleAllele.length);
        this.involvedRuleAllele[pos] = (int)(rand.Rand() * (double)this.numberOfConsequents);
    }

    @Override
    public void debug() {
        int i;
        String s = "GenotypePitts [";
        for (i = 0; i < this.involvedRuleAllele.length; ++i) {
            s = s + this.involvedRuleAllele[i] + " ";
        }
        s = s + "] [";
        for (i = 0; i < this.ruleWeightAllele.length; ++i) {
            s = s + this.ruleWeightAllele[i] + " ";
        }
        s = s + "]";
        System.out.println(s);
    }

    public int getInvolvedRule(int n) {
        return this.involvedRuleAllele[n];
    }

    public void setInvolvedRule(int n, int v) {
        this.involvedRuleAllele[n] = v;
    }

    public double getRuleWeight(int n) {
        return this.ruleWeightAllele[n];
    }

    public void setRuleWeight(int n, double v) {
        this.ruleWeightAllele[n] = v;
    }

    public int size() {
        return this.involvedRuleAllele.length;
    }
}

