/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.BasicMethods;

import java.util.ArrayList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class AVG
extends PrototypeGenerator {
    public AVG(PrototypeSet _trainingDataSet) {
        super(_trainingDataSet);
        this.algorithmName = "AVG";
    }

    public AVG(PrototypeSet _trainingDataSet, Parameters param) {
        super(_trainingDataSet, param);
        this.algorithmName = "AVG";
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet reduced = new PrototypeSet();
        ArrayList<Double> classes = this.trainingDataSet.nonVoidClasses();
        for (double c : classes) {
            PrototypeSet Tc = this.trainingDataSet.getFromClass(c);
            Prototype centroid_c = Tc.avg();
            centroid_c.setLabel(c);
            reduced.add(centroid_c);
        }
        return reduced;
    }

    public static void main(String[] args) {
        Parameters.setUse("AVG", "");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        AVG generator = new AVG(training);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

