/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aeoptimizer;

import com.amazon.sqlengine.aeprocessor.AEColumnInfo;
import com.amazon.sqlengine.aeprocessor.aemanipulator.AETreeManipulator;
import com.amazon.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.amazon.sqlengine.aeprocessor.aeoptimizer.AEPassdownJoin;
import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESort;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETable;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETop;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.amazon.sqlengine.dsiext.dataengine.IAggregationHandler;
import com.amazon.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.amazon.sqlengine.dsiext.dataengine.IDistinctHandler;
import com.amazon.sqlengine.dsiext.dataengine.IProjectionHandler;
import com.amazon.sqlengine.dsiext.dataengine.ISortHandler;
import com.amazon.sqlengine.dsiext.dataengine.ITopHandler;
import com.amazon.sqlengine.dsiext.dataengine.IUnionHandler;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.Iterator;

public class AERelationalExprHandler {
    private DSIExtOperationHandlerFactory m_opHandlerFactory;

    public AERelationalExprHandler(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
    }

    public AERelationalExpr passdown(AERelationalExpr aERelationalExpr) {
        return AERelationalExprHandler.suppressedAcceptVisitor(aERelationalExpr, new RelationalExprVisitor(aERelationalExpr));
    }

    private static <T> T suppressedAcceptVisitor(IAENode iAENode, IAENodeVisitor<T> iAENodeVisitor) {
        try {
            return iAENode.acceptVisitor(iAENodeVisitor);
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }

    private static void replaceProxyColumns(final AERelationalExpr aERelationalExpr, final AETable aETable) {
        assert (null != aETable);
        AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEProxyColumn aEProxyColumn) {
                if (aEProxyColumn.getRelationalExpr() == aERelationalExpr) {
                    AEColumnReference aEColumnReference = new AEColumnReference(new AEColumnInfo(aETable, aEProxyColumn.getColumnNumber(), false));
                    try {
                        AETreeManipulator.replaceValueExpr(aEProxyColumn, aEColumnReference);
                    }
                    catch (ErrorException errorException) {
                        throw SQLEngineExceptionFactory.runtimeException(errorException);
                    }
                }
                return null;
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    IAENode iAENode2 = iterator.next();
                    if (iAENode2 == aERelationalExpr) continue;
                    iAENode2.acceptVisitor(this);
                }
                return null;
            }
        };
        try {
            AERelationalExprHandler.findRoot(aERelationalExpr).acceptVisitor(aEDefaultVisitor);
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }

    private static IAENode findRoot(IAENode iAENode) {
        IAENode iAENode2 = iAENode;
        while (null != iAENode2.getParent()) {
            iAENode2 = iAENode2.getParent();
        }
        return iAENode2;
    }

    private static class SubQueryReplacer
    extends AEDefaultVisitor<Void> {
        private AERelationalExpr m_replacement = null;

        private SubQueryReplacer() {
        }

        public void replace(AESubQuery aESubQuery, AERelationalExpr aERelationalExpr) {
            assert (aESubQuery.getParent() instanceof AEBooleanExpr);
            this.m_replacement = aERelationalExpr;
            AERelationalExprHandler.suppressedAcceptVisitor(aESubQuery.getParent(), this);
            this.m_replacement = null;
        }

        @Override
        public Void visit(AEExistsPredicate aEExistsPredicate) {
            aEExistsPredicate.setOperand(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEInPredicate aEInPredicate) {
            aEInPredicate.setRightOperand(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AEQuantifiedComparison aEQuantifiedComparison) {
            aEQuantifiedComparison.setRightOperand(this.m_replacement);
            return null;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) {
            throw SQLEngineExceptionFactory.runtimeException(SQLEngineExceptionFactory.invalidAETreeException());
        }
    }

    private class PassdownSubQuery
    extends AEDefaultVisitor<Void> {
        private PassdownSubQuery() {
        }

        @Override
        public Void visit(AEValueSubQuery aEValueSubQuery) {
            if (aEValueSubQuery.isCorrelated()) {
                return null;
            }
            AERelationalExpr aERelationalExpr = AERelationalExprHandler.this.passdown(aEValueSubQuery.getQueryExpression());
            if (null != aERelationalExpr) {
                aEValueSubQuery.setQueryExpression(aERelationalExpr);
            }
            return null;
        }

        @Override
        public Void visit(AESubQuery aESubQuery) {
            if (aESubQuery.isCorrelated()) {
                return null;
            }
            AERelationalExpr aERelationalExpr = AERelationalExprHandler.this.passdown(aESubQuery.getOperand());
            if (null != aERelationalExpr && aERelationalExpr instanceof AETable) {
                new SubQueryReplacer().replace(aESubQuery, aERelationalExpr);
            }
            return null;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) {
            Iterator<? extends IAENode> iterator = iAENode.getChildItr();
            while (iterator.hasNext()) {
                AERelationalExprHandler.suppressedAcceptVisitor(iterator.next(), this);
            }
            return null;
        }
    }

    private class RelationalExprVisitor
    extends AEDefaultVisitor<AERelationalExpr> {
        public RelationalExprVisitor(AERelationalExpr aERelationalExpr) {
        }

        @Override
        public AERelationalExpr visit(AEProject aEProject) {
            AERelationalExprHandler.suppressedAcceptVisitor(aEProject.getProjectionList(), new PassdownSubQuery());
            if (!this.passdownOperand(aEProject)) {
                return aEProject;
            }
            assert (aEProject.getOperand() instanceof AETable);
            IProjectionHandler iProjectionHandler = AERelationalExprHandler.this.m_opHandlerFactory.createProjectionHandler(((AETable)aEProject.getOperand()).getTable());
            if (null == iProjectionHandler) {
                return aEProject;
            }
            AERelationalExpr aERelationalExpr = iProjectionHandler.passdown(aEProject);
            if (null == aERelationalExpr) {
                return aEProject;
            }
            return aERelationalExpr;
        }

        @Override
        public AERelationalExpr visit(AETable aETable) {
            return aETable;
        }

        @Override
        public AERelationalExpr visit(AESelect aESelect) {
            AERelationalExprHandler.suppressedAcceptVisitor(aESelect.getCondition(), new PassdownSubQuery());
            if (!this.passdownOperand(aESelect)) {
                return aESelect;
            }
            assert (aESelect.getOperand() instanceof AETable);
            AETable aETable = (AETable)aESelect.getOperand();
            IBooleanExprHandler iBooleanExprHandler = AERelationalExprHandler.this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
            if (null == iBooleanExprHandler) {
                return null;
            }
            Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aESelect.getCondition());
            if (pair.key() != null) {
                aETable.setTable(pair.key());
            }
            if (pair.value() == null) {
                return aETable;
            }
            aESelect.setSelectCond(pair.value());
            return aESelect;
        }

        @Override
        public AERelationalExpr visit(AETop aETop) {
            DSIExtJResultSet dSIExtJResultSet;
            if (!this.passdownOperand(aETop)) {
                return aETop;
            }
            assert (aETop.getOperand() instanceof AETable);
            ITopHandler iTopHandler = AERelationalExprHandler.this.m_opHandlerFactory.createTopHandler(((AETable)aETop.getOperand()).getTable());
            if (null != iTopHandler && null != (dSIExtJResultSet = iTopHandler.passdown(aETop))) {
                AETable aETable;
                try {
                    aETable = new AETable(dSIExtJResultSet);
                }
                catch (ErrorException errorException) {
                    return aETop;
                }
                aETable.overrideCorrelationSpec((AETable)aETop.getOperand());
                return aETable;
            }
            return aETop;
        }

        @Override
        public AERelationalExpr visit(AESort aESort) {
            if (!this.passdownOperand(aESort)) {
                return aESort;
            }
            assert (aESort.getOperand() instanceof AETable);
            ISortHandler iSortHandler = AERelationalExprHandler.this.m_opHandlerFactory.createSortHandler(((AETable)aESort.getOperand()).getTable());
            if (iSortHandler == null) {
                return aESort;
            }
            ISortHandler.ISortPassdownResult iSortPassdownResult = iSortHandler.passdown(aESort);
            if (iSortPassdownResult == null) {
                return aESort;
            }
            assert (iSortPassdownResult.getNumOfPrefixColumns() <= aESort.getSortSpecs().size());
            if (iSortPassdownResult.getNumOfPrefixColumns() == aESort.getSortSpecs().size() && iSortPassdownResult.getSortOrder() == AETable.SESortOrder.ODBC_ORDER) {
                AETable aETable;
                AETable.SESortInfo sESortInfo = new AETable.SESortInfo(AETable.SESortOrder.ODBC_ORDER, aESort.getSortSpecs());
                try {
                    aETable = new AETable(iSortPassdownResult.getResultSet(), sESortInfo);
                }
                catch (ErrorException errorException) {
                    return aESort;
                }
                int[] nArray = new int[aETable.getColumnCount()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i;
                }
                aETable.overrideCorrelationSpec((AETable)aESort.getOperand(), nArray);
                return aETable;
            }
            return aESort;
        }

        @Override
        public AERelationalExpr visit(AECrossJoin aECrossJoin) {
            this.passdownOperand(aECrossJoin);
            return aECrossJoin;
        }

        @Override
        public AERelationalExpr visit(AEJoin aEJoin) {
            AERelationalExprHandler.suppressedAcceptVisitor(aEJoin.getJoinCondition(), new PassdownSubQuery());
            if (!this.passdownOperand(aEJoin)) {
                return aEJoin;
            }
            return new AEPassdownJoin(AERelationalExprHandler.this.m_opHandlerFactory).passdown(aEJoin);
        }

        @Override
        public AERelationalExpr visit(AEAggregate aEAggregate) {
            DSIExtJResultSet dSIExtJResultSet;
            if (!this.passdownOperand(aEAggregate)) {
                return aEAggregate;
            }
            assert (aEAggregate.getOperand() instanceof AETable);
            IAggregationHandler iAggregationHandler = AERelationalExprHandler.this.m_opHandlerFactory.createAggregationHandler(((AETable)aEAggregate.getOperand()).getTable());
            if (null != iAggregationHandler && null != (dSIExtJResultSet = iAggregationHandler.passdown(aEAggregate))) {
                AETable aETable;
                try {
                    aETable = new AETable(dSIExtJResultSet);
                }
                catch (ErrorException errorException) {
                    throw SQLEngineExceptionFactory.runtimeException(errorException);
                }
                int[] nArray = this.mapCorrelationSpec(aEAggregate, aETable);
                AERelationalExprHandler.replaceProxyColumns(aEAggregate, aETable);
                aETable.overrideCorrelationSpec((AETable)aEAggregate.getOperand(), nArray);
                return aETable;
            }
            return aEAggregate;
        }

        @Override
        public AERelationalExpr visit(AEDistinct aEDistinct) {
            DSIExtJResultSet dSIExtJResultSet;
            if (!this.passdownOperand(aEDistinct)) {
                return aEDistinct;
            }
            assert (aEDistinct.getOperand() instanceof AETable);
            IDistinctHandler iDistinctHandler = AERelationalExprHandler.this.m_opHandlerFactory.createDistinctHandler(((AETable)aEDistinct.getOperand()).getTable());
            if (null != iDistinctHandler && null != (dSIExtJResultSet = iDistinctHandler.passdown(aEDistinct))) {
                AETable aETable;
                try {
                    aETable = new AETable(dSIExtJResultSet);
                }
                catch (ErrorException errorException) {
                    return aEDistinct;
                }
                aETable.overrideCorrelationSpec((AETable)aEDistinct.getOperand());
                return aETable;
            }
            return aEDistinct;
        }

        @Override
        public AERelationalExpr visit(AESubQuery aESubQuery) {
            AERelationalExpr aERelationalExpr;
            AERelationalExpr aERelationalExpr2;
            if (aESubQuery.isInFromClause() && !aESubQuery.isCorrelated() && null != (aERelationalExpr2 = AERelationalExprHandler.this.passdown(aERelationalExpr = aESubQuery.getOperand()))) {
                if (aERelationalExpr2 instanceof AETable) {
                    AETable aETable = (AETable)aERelationalExpr2;
                    aETable.overrideCorrelationSpec(aESubQuery);
                    this.updateColumns(aESubQuery, (AETable)aERelationalExpr2);
                    return aERelationalExpr2;
                }
                aESubQuery.setOperand(aERelationalExpr2);
            }
            return aESubQuery;
        }

        @Override
        public AERelationalExpr visit(AETableConstructor aETableConstructor) {
            return aETableConstructor;
        }

        @Override
        public AERelationalExpr visit(AEUnion aEUnion) {
            if (!this.passdownOperand(aEUnion)) {
                return aEUnion;
            }
            assert (aEUnion.getLeftOperand() instanceof AETable && aEUnion.getRightOperand() instanceof AETable);
            IUnionHandler iUnionHandler = AERelationalExprHandler.this.m_opHandlerFactory.createUnionHandler();
            if (iUnionHandler == null) {
                return aEUnion;
            }
            DSIExtJResultSet dSIExtJResultSet = iUnionHandler.passdown(((AETable)aEUnion.getLeftOperand()).getTable(), ((AETable)aEUnion.getRightOperand()).getTable(), aEUnion.getResultSetColumns(), aEUnion.isAllOptPresent());
            if (null != dSIExtJResultSet) {
                AETable aETable;
                try {
                    aETable = new AETable(dSIExtJResultSet);
                }
                catch (ErrorException errorException) {
                    return aEUnion;
                }
                aETable.overrideCorrelationSpec((AETable)aEUnion.getLeftOperand());
                return aETable;
            }
            return aEUnion;
        }

        @Override
        protected AERelationalExpr defaultVisit(IAENode iAENode) {
            throw SQLEngineExceptionFactory.runtimeException(SQLEngineExceptionFactory.invalidAETreeException());
        }

        private int[] mapCorrelationSpec(AEAggregate aEAggregate, AETable aETable) {
            final int[] nArray = new int[aETable.getColumnCount()];
            Arrays.fill(nArray, -1);
            AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){
                private int m_count = 0;

                @Override
                public Void visit(AEColumnReference aEColumnReference) {
                    nArray[this.m_count++] = aEColumnReference.getColumnNum();
                    return null;
                }

                @Override
                protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                    ++this.m_count;
                    return null;
                }
            };
            Iterator iterator = aEAggregate.getAggregationList().getChildItr();
            while (iterator.hasNext()) {
                AERelationalExprHandler.suppressedAcceptVisitor((IAENode)iterator.next(), aEDefaultVisitor);
            }
            return nArray;
        }

        private boolean passdownOperand(AEUnaryRelationalExpr aEUnaryRelationalExpr) {
            AERelationalExpr aERelationalExpr = aEUnaryRelationalExpr.getOperand();
            if (aERelationalExpr instanceof AETable) {
                return true;
            }
            AERelationalExpr aERelationalExpr2 = AERelationalExprHandler.this.passdown(aERelationalExpr);
            if (null != aERelationalExpr2) {
                aEUnaryRelationalExpr.getOperand().setParent(null);
                aEUnaryRelationalExpr.setOperand(aERelationalExpr2);
            }
            return aERelationalExpr2 instanceof AETable;
        }

        private boolean passdownOperand(AEBinaryRelationalExpr aEBinaryRelationalExpr) {
            AERelationalExpr aERelationalExpr = aEBinaryRelationalExpr.getLeftOperand();
            AERelationalExpr aERelationalExpr2 = aEBinaryRelationalExpr.getRightOperand();
            AERelationalExpr aERelationalExpr3 = null;
            if (!(aERelationalExpr instanceof AETable) && null != (aERelationalExpr3 = AERelationalExprHandler.this.passdown(aERelationalExpr))) {
                aEBinaryRelationalExpr.setLeftOperand(aERelationalExpr3);
            }
            if (!(aERelationalExpr2 instanceof AETable) && null != (aERelationalExpr3 = AERelationalExprHandler.this.passdown(aERelationalExpr2))) {
                aEBinaryRelationalExpr.setRightOperand(aERelationalExpr3);
            }
            return aEBinaryRelationalExpr.getLeftOperand() instanceof AETable && aEBinaryRelationalExpr.getRightOperand() instanceof AETable;
        }

        private void updateColumns(final AENamedRelationalExpr aENamedRelationalExpr, final AENamedRelationalExpr aENamedRelationalExpr2) {
            IAENode iAENode = aENamedRelationalExpr.getParent();
            while (iAENode.getParent() != null && !(iAENode instanceof AESubQuery)) {
                iAENode = iAENode.getParent();
            }
            try {
                AETreeWalker.walk(iAENode, new AETreeWalker.Action<Void>(){

                    @Override
                    public void act(IAENode iAENode) {
                        AEColumnReference aEColumnReference;
                        if (iAENode == aENamedRelationalExpr) {
                            this.skipChildren();
                        }
                        if (iAENode instanceof AEColumnReference && (aEColumnReference = (AEColumnReference)iAENode).getNamedRelationalExpr() == aENamedRelationalExpr) {
                            aEColumnReference.setNamedRelationalExpr(aENamedRelationalExpr2);
                        }
                    }
                });
            }
            catch (ErrorException errorException) {
                throw SQLEngineExceptionFactory.runtimeException(errorException);
            }
        }
    }
}

