/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.Datum;
import oracle.sql.ROWID;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeROWID
extends OracleType
implements Serializable {
    private static final long serialVersionUID = -8461138981231838724L;

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof ROWID) {
                return (Datum)object;
            }
            if (object instanceof String) {
                return new ROWID((String)object);
            }
            if (object instanceof byte[]) {
                return new ROWID((byte[])object);
            }
        }
        return null;
    }

    @Override
    public int getTypeCode() throws SQLException {
        return -8;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        return new ROWID(byArray);
    }
}

