/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions.gp;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.MathUtils;
import dr.math.distributions.gp.AdditiveGaussianProcessDistribution;
import dr.math.distributions.gp.GaussianProcessKernel;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.List;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon_D64;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class GaussianProcessPrediction
implements Reportable,
Loggable,
VariableListener,
ModelListener {
    protected static AdditiveGaussianProcessDistribution gp;
    private final Parameter realizedValues;
    private static List<DesignMatrix> predictiveDesigns;
    private final int realizedDim;
    private final int predictiveDim;
    private final Parameter orderVariance;
    private final double[] prediction;
    protected double[] mean;
    protected DenseMatrix64F variance;
    private final DenseMatrix64F crossGramian;
    private DenseMatrix64F realizedPrecision;
    protected final LinearSolver<DenseMatrix64F> solver;
    protected final DenseMatrix64F crossRealized;
    private boolean predictionKnown;
    protected boolean meanKnown;
    private boolean varianceKnown;
    private boolean crossRealizedKnown;
    private boolean crossGramianKnown;
    private LogColumn[] columns;

    public GaussianProcessPrediction(AdditiveGaussianProcessDistribution additiveGaussianProcessDistribution, Parameter parameter, List<DesignMatrix> list) {
        gp = additiveGaussianProcessDistribution;
        this.realizedValues = parameter;
        predictiveDesigns = list;
        this.realizedDim = additiveGaussianProcessDistribution.getDimension();
        this.predictiveDim = list.get(0).getRowDimension();
        this.orderVariance = additiveGaussianProcessDistribution.getOrderVariance();
        this.crossGramian = new DenseMatrix64F(this.predictiveDim, this.realizedDim);
        this.realizedPrecision = new DenseMatrix64F(this.realizedDim, this.realizedDim);
        this.crossRealized = new DenseMatrix64F(this.predictiveDim, this.realizedDim);
        this.mean = new double[this.predictiveDim];
        this.variance = new DenseMatrix64F(this.predictiveDim, this.predictiveDim);
        this.prediction = new double[this.predictiveDim];
        this.solver = LinearSolverFactory.symmPosDef(this.realizedDim);
        additiveGaussianProcessDistribution.addModelListener(this);
        parameter.addVariableListener(this);
        for (DesignMatrix designMatrix : list) {
            designMatrix.addVariableListener(this);
        }
        this.predictionKnown = false;
        this.meanKnown = false;
        this.varianceKnown = false;
        this.crossRealizedKnown = false;
        this.crossGramianKnown = false;
    }

    protected List<AdditiveGaussianProcessDistribution.BasisDimension> makeBases(boolean bl) {
        ArrayList<AdditiveGaussianProcessDistribution.BasisDimension> arrayList = new ArrayList<AdditiveGaussianProcessDistribution.BasisDimension>();
        List<AdditiveGaussianProcessDistribution.BasisDimension> list = gp.getBases();
        for (int i = 0; i < list.size(); ++i) {
            AdditiveGaussianProcessDistribution.BasisDimension basisDimension = list.get(i);
            GaussianProcessKernel gaussianProcessKernel = basisDimension.getKernel();
            DesignMatrix designMatrix = predictiveDesigns.get(i);
            DesignMatrix designMatrix2 = !bl ? basisDimension.getDesignMatrix1() : designMatrix;
            AdditiveGaussianProcessDistribution.BasisDimension basisDimension2 = new AdditiveGaussianProcessDistribution.BasisDimension(gaussianProcessKernel, designMatrix, designMatrix2);
            arrayList.add(basisDimension2);
        }
        return arrayList;
    }

    protected List<AdditiveGaussianProcessDistribution.BasisDimension> makeCrossBases() {
        return this.makeBases(false);
    }

    protected List<AdditiveGaussianProcessDistribution.BasisDimension> makePredictiveBases() {
        return this.makeBases(true);
    }

    protected void computeCholesky() {
        if (!this.solver.setA(this.variance)) {
            throw new RuntimeException("Unable to decompose matrix");
        }
    }

    private void computePredictions() {
        int n;
        this.computeMean();
        this.computeVariance();
        this.computeCholesky();
        DenseMatrix64F denseMatrix64F = ((CholeskyDecompositionCommon_D64)this.solver.getDecomposition()).getT();
        double[] dArray = new double[this.predictiveDim];
        for (n = 0; n < this.predictiveDim; ++n) {
            dArray[n] = MathUtils.nextGaussian();
        }
        for (n = 0; n < this.predictiveDim; ++n) {
            this.prediction[n] = 0.0;
            for (int i = 0; i < this.predictiveDim; ++i) {
                int n2 = n;
                this.prediction[n2] = this.prediction[n2] + denseMatrix64F.get(n, i) * dArray[i];
            }
            int n3 = n;
            this.prediction[n3] = this.prediction[n3] + this.mean[n];
        }
    }

    private double getPrediction(int n) {
        if (!this.predictionKnown) {
            this.computePredictions();
            this.predictionKnown = true;
        }
        if (n == this.predictiveDim - 1) {
            this.predictionKnown = false;
        }
        return this.prediction[n];
    }

    private void computeCrossGramian() {
        if (!this.crossGramianKnown) {
            List<AdditiveGaussianProcessDistribution.BasisDimension> list = this.makeCrossBases();
            AdditiveGaussianProcessDistribution.computeAdditiveGramian(this.crossGramian, list, this.orderVariance);
            this.crossGramianKnown = true;
        }
    }

    protected void computeCrossRealized() {
        if (!this.crossRealizedKnown) {
            this.computeCrossGramian();
            this.realizedPrecision = gp.getPrecisionAsMatrix();
            CommonOps.mult(this.crossGramian, this.realizedPrecision, this.crossRealized);
            this.crossRealizedKnown = true;
        }
    }

    private DenseMatrix64F getPredictiveGramian() {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.predictiveDim, this.predictiveDim);
        List<AdditiveGaussianProcessDistribution.BasisDimension> list = this.makePredictiveBases();
        AdditiveGaussianProcessDistribution.computeAdditiveGramian(denseMatrix64F, list, this.orderVariance);
        return denseMatrix64F;
    }

    protected void computeMean() {
        if (!this.meanKnown) {
            this.computeCrossRealized();
            double[] dArray = gp.getMean();
            for (int i = 0; i < this.predictiveDim; ++i) {
                this.mean[i] = 0.0;
                for (int j = 0; j < this.realizedDim; ++j) {
                    int n = i;
                    this.mean[n] = this.mean[n] + this.crossRealized.get(i, j) * (this.realizedValues.getParameterValue(j) - dArray[j]);
                }
            }
            this.meanKnown = true;
        }
    }

    protected void computeVariance() {
        if (!this.varianceKnown) {
            this.computeCrossRealized();
            DenseMatrix64F denseMatrix64F = this.getPredictiveGramian();
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.predictiveDim, this.predictiveDim);
            for (int i = 0; i < this.crossRealized.numRows; ++i) {
                for (int j = 0; j < this.crossGramian.numRows; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < this.crossRealized.numCols; ++k) {
                        d += this.crossRealized.get(i, k) * this.crossGramian.get(j, k);
                    }
                    denseMatrix64F2.set(i, j, d);
                }
            }
            CommonOps.subtract((D1Matrix64F)denseMatrix64F, (D1Matrix64F)denseMatrix64F2, (D1Matrix64F)this.variance);
        }
    }

    private double[] getMean() {
        this.computeMean();
        return this.mean;
    }

    private double[] getVariance() {
        this.computeVariance();
        return this.variance.getData();
    }

    private LogColumn[] createColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.predictiveDim];
        for (int i = 0; i < this.predictiveDim; ++i) {
            String string = "prediction" + (i + 1);
            final int n = i;
            logColumnArray[i] = new NumberColumn(string){

                @Override
                public double getDoubleValue() {
                    return GaussianProcessPrediction.this.getPrediction(n);
                }
            };
        }
        return logColumnArray;
    }

    @Override
    public LogColumn[] getColumns() {
        if (this.columns == null) {
            this.columns = this.createColumns();
        }
        return this.columns;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mean:");
        for (double d : this.getMean()) {
            stringBuilder.append(" ").append(d);
        }
        stringBuilder.append("\n");
        stringBuilder.append("variance:");
        for (double d : this.getVariance()) {
            stringBuilder.append(" ").append(d);
        }
        stringBuilder.append("\n");
        stringBuilder.append("prediction:");
        for (int i = 0; i < this.predictiveDim; ++i) {
            stringBuilder.append(" ").append(this.getPrediction(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        if (model != gp) {
            throw new IllegalArgumentException("Unknown model");
        }
        this.predictionKnown = false;
        this.meanKnown = false;
        this.varianceKnown = false;
        this.crossRealizedKnown = false;
        this.crossGramianKnown = false;
    }

    @Override
    public void modelRestored(Model model) {
        this.predictionKnown = false;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.realizedValues) {
            if (variable instanceof DesignMatrix && predictiveDesigns.contains((DesignMatrix)variable)) {
                throw new IllegalArgumentException("Not yet implemented");
            }
            throw new IllegalArgumentException("Unknown variable");
        }
        this.predictionKnown = false;
        this.meanKnown = false;
    }
}

