/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.Consensus;
import dr.evolution.alignment.ConvertAlignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.io.Importer;
import dr.evolution.io.NexusImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.util.TaxonList;
import dr.stats.DiscreteStatistics;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class Defects {
    private final ArrayList<Defect> defects = new ArrayList();
    private final Set<Integer> defectiveSequences = new HashSet<Integer>();
    private final Set<Integer> defectiveSites = new HashSet<Integer>();
    int sequenceCount = 0;
    static final int STOP = -1;
    static final int INDEL = -2;
    int totalReads = 0;

    public Defects(Alignment alignment) {
        Codons codons = Codons.UNIVERSAL;
        Nucleotides nucleotides = Nucleotides.INSTANCE;
        ConvertAlignment convertAlignment = new ConvertAlignment((DataType)codons, alignment);
        this.sequenceCount = convertAlignment.getSequenceCount();
        for (int i = 0; i < convertAlignment.getSequenceCount(); ++i) {
            for (int j = 0; j < convertAlignment.getSiteCount(); ++j) {
                int n = convertAlignment.getState(i, j);
                if (codons.isStopCodon(n)) {
                    this.addDefect(-1, i, j);
                    ++this.totalReads;
                    continue;
                }
                if (codons.isGapState(n)) {
                    int n2 = j * 3;
                    int n3 = alignment.getState(i, n2);
                    int n4 = alignment.getState(i, n2 + 1);
                    int n5 = alignment.getState(i, n2 + 2);
                    if (nucleotides.isGapState(n3) && nucleotides.isGapState(n4) && nucleotides.isGapState(n5)) continue;
                    this.addDefect(-2, i, j);
                    continue;
                }
                ++this.totalReads;
            }
        }
    }

    private void addDefect(int n, int n2, int n3) {
        this.defects.add(new Defect(n, n2, n3));
        this.defectiveSequences.add(n2);
        this.defectiveSites.add(n3);
    }

    public int getDefectiveSequenceCount() {
        return this.defectiveSequences.size();
    }

    public int getDefectiveSiteCount() {
        return this.defectiveSites.size();
    }

    public int getDefectiveSites(int n) {
        int n2 = 0;
        for (Defect defect : this.defects) {
            if (defect.getSequence() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getStopSites(int n) {
        int n2 = 0;
        for (Defect defect : this.defects) {
            if (defect.getSequence() != n || !defect.isStop()) continue;
            ++n2;
        }
        return n2;
    }

    public int getDefectiveSequences(int n) {
        int n2 = 0;
        for (Defect defect : this.defects) {
            if (defect.getSequence() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getDefectCount() {
        return this.defects.size();
    }

    public int getStopCodonCount() {
        int n = 0;
        for (Defect defect : this.defects) {
            if (!defect.isStop()) continue;
            ++n;
        }
        return n;
    }

    public int getSequenceCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.sequenceCount; ++i) {
            if (this.getDefectiveSites(i) != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getMaxDefectiveSites() {
        int n = 0;
        for (int i = 0; i < this.sequenceCount; ++i) {
            int n2 = this.getDefectiveSites(i);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getMaxStopSites() {
        int n = 0;
        for (int i = 0; i < this.sequenceCount; ++i) {
            int n2 = this.getStopSites(i);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public Set<Integer> getSequences(int n) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.sequenceCount; ++i) {
            if (this.getDefectiveSites(i) != n) continue;
            treeSet.add(i);
        }
        return treeSet;
    }

    public Set<Integer> getSequencesByStopCount(int n) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.sequenceCount; ++i) {
            if (this.getStopSites(i) != n) continue;
            treeSet.add(i);
        }
        return treeSet;
    }

    public int getStopSequenceCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.sequenceCount; ++i) {
            if (this.getStopSites(i) != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getTotalCodonsMinusGaps() {
        return this.totalReads;
    }

    private static Alignment readNexusFile(String string) throws IOException {
        Alignment alignment = null;
        TaxonList taxonList = null;
        try {
            FileReader fileReader = new FileReader(string);
            NexusImporter nexusImporter = new NexusImporter(fileReader);
            boolean bl = false;
            while (!bl) {
                try {
                    NexusImporter.NexusBlock nexusBlock = nexusImporter.findNextBlock();
                    if (nexusBlock == NexusImporter.TAXA_BLOCK) {
                        if (taxonList != null) {
                            throw new NexusImporter.MissingBlockException("TAXA block already defined");
                        }
                        taxonList = nexusImporter.parseTaxaBlock();
                        continue;
                    }
                    if (nexusBlock == NexusImporter.DATA_BLOCK) {
                        alignment = nexusImporter.parseDataBlock(taxonList);
                        if (taxonList != null) continue;
                        taxonList = alignment;
                        continue;
                    }
                    if (nexusBlock != NexusImporter.TREES_BLOCK) continue;
                }
                catch (EOFException eOFException) {
                    bl = true;
                }
            }
        }
        catch (Importer.ImportException importException) {
            System.err.println("Error reading alignment: " + importException);
        }
        return alignment;
    }

    private static int[][] generateTransversionMutants(int[] nArray) {
        int n;
        int n2;
        int[][] nArray2 = new int[6][3];
        for (n2 = 0; n2 < 6; ++n2) {
            for (n = 0; n < 3; ++n) {
                nArray2[n2][n] = nArray[n];
            }
        }
        n2 = 0;
        for (n = 0; n < 3; ++n) {
            if (nArray[n] % 2 == 0) {
                nArray2[n2++][n] = 1;
                nArray2[n2++][n] = 3;
                continue;
            }
            nArray2[n2++][n] = 0;
            nArray2[n2++][n] = 2;
        }
        return nArray2;
    }

    private static int[][] generateTransitionMutants(int[] nArray) {
        int n;
        int[][] nArray2 = new int[3][3];
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < 3; ++i) {
                nArray2[n][i] = nArray[i];
            }
        }
        block8: for (n = 0; n < 3; ++n) {
            switch (nArray[n]) {
                case 0: {
                    nArray2[n][n] = 2;
                    continue block8;
                }
                case 1: {
                    nArray2[n][n] = 3;
                    continue block8;
                }
                case 2: {
                    nArray2[n][n] = 0;
                    continue block8;
                }
                case 3: {
                    nArray2[n][n] = 1;
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return nArray2;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        Serializable serializable2;
        int n;
        Object object2;
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        Alignment alignment = Defects.readNexusFile(string);
        Defects defects = new Defects(alignment);
        int n2 = alignment.getSiteCount() / 3;
        int n3 = alignment.getSequenceCount();
        int n4 = n2 * n3;
        int n5 = defects.getTotalCodonsMinusGaps();
        int n6 = defects.getDefectiveSiteCount();
        int n7 = defects.getDefectiveSequenceCount();
        int n8 = defects.getDefectCount();
        int n9 = defects.getStopCodonCount();
        double d = (double)n6 / (double)n2;
        double d2 = (double)n7 / (double)n3;
        double d3 = (double)n8 / (double)n5;
        double d4 = (double)n9 / (double)n5;
        System.out.println("Matrix size=" + n4);
        System.out.println("Non-gap codons=" + n5);
        System.out.println(n7 + "/" + n3 + "(" + d2 + ") defective sequences.");
        System.out.println(n6 + "/" + n2 + "(" + d + ") defective sites.");
        System.out.println(n8 + "/" + n5 + "(" + d3 + ") defects.");
        System.out.println(n9 + "/" + n5 + "(" + d4 + ") stop codons.");
        double d5 = (double)n8 / (double)n3;
        System.out.println(d5 + " defects per sequence");
        double d6 = (double)n9 / (double)n3;
        System.out.println(d6 + " stops per sequence");
        int n10 = defects.getMaxDefectiveSites();
        int n11 = defects.getMaxStopSites();
        System.out.println("defective sequences:");
        for (int i = 1; i <= n10; ++i) {
            Set<Integer> set = defects.getSequences(i);
            for (Integer object32 : set) {
                object2 = alignment.getTaxonId(object32);
                System.out.println(i + "  " + (String)object2);
            }
        }
        System.out.println("Defects\tSequences\texpected");
        double d7 = Math.exp(-d5);
        for (n = 0; n < 10; ++n) {
            System.out.println(n + "\t" + defects.getSequenceCount(n) + "\t" + d7 * (double)n3);
            d7 *= d5 / (double)(n + 1);
        }
        System.out.println("Stops\tSequences\texpected");
        d7 = Math.exp(-d6);
        for (n = 0; n < 10; ++n) {
            System.out.println(n + "\t" + defects.getStopSequenceCount(n) + "\t" + d7 * (double)n3);
            d7 *= d6 / (double)(n + 1);
        }
        System.out.println("stop-codon sequences:");
        for (n = 1; n <= n11; ++n) {
            Set<Integer> set = defects.getSequencesByStopCount(n);
            for (Serializable serializable2 : set) {
                object = alignment.getTaxonId((Integer)serializable2);
                System.out.println(n + "  " + (String)object);
            }
        }
        Consensus consensus = new Consensus("mode", alignment, true);
        Sequence sequence = consensus.getConsensusSequence();
        object2 = new SimpleAlignment();
        ((SimpleAlignment)object2).addSequence(new Sequence(sequence));
        serializable2 = new ConvertAlignment((DataType)Codons.UNIVERSAL, (Alignment)object2);
        object = new double[((ConvertAlignment)serializable2).getSiteCount()];
        int[] nArray = new int[10];
        for (double d8 = 2.0; d8 <= 2.0; d8 += 1.0) {
            for (int i = 0; i < ((ConvertAlignment)serializable2).getSiteCount(); ++i) {
                int n12;
                int n13 = ((ConvertAlignment)serializable2).getState(0, i);
                if (Codons.UNIVERSAL.isStopCodon(n13)) {
                    throw new RuntimeException("Consensus has a stop codon in it at position " + i + "!");
                }
                int[] nArray2 = Codons.UNIVERSAL.getTripletStates(n13);
                int[][] nArray3 = Defects.generateTransversionMutants(nArray2);
                int[][] nArray4 = Defects.generateTransitionMutants(nArray2);
                int n14 = 0;
                for (n12 = 0; n12 < 6; ++n12) {
                    if (!Codons.UNIVERSAL.isStopCodon(Codons.UNIVERSAL.getState(nArray3[n12][0], nArray3[n12][1], nArray3[n12][2]))) continue;
                    ++n14;
                }
                n12 = 0;
                for (int j = 0; j < 3; ++j) {
                    if (!Codons.UNIVERSAL.isStopCodon(Codons.UNIVERSAL.getState(nArray4[j][0], nArray4[j][1], nArray4[j][2]))) continue;
                    ++n12;
                }
                object[i] = ((double)n14 + d8 * (double)n12) / (6.0 + d8 * 3.0);
                int n15 = n14 + n12;
                nArray[n15] = nArray[n15] + 1;
            }
            System.out.println("kappa = " + d8 + " pstop=" + DiscreteStatistics.mean((double[])object));
        }
        System.out.println("stop-mutations\tcodons");
        for (int i = 0; i < 10; ++i) {
            System.out.println(i + "\t" + nArray[i]);
        }
        double d9 = DiscreteStatistics.mean((double[])object);
        double d10 = d4 * (1.0 - d9) / d9;
        System.out.println("Total inferred point-mutation rate = " + d10);
        System.out.println("Total inferred point-mutations = " + (double)n9 * (1.0 - d9) / d9);
        System.out.println("Proportion of point-mutations that produce premature stop codons = " + d9);
    }

    class Defect {
        private int type = 0;
        private int sequence = 0;
        private int site = 0;

        public Defect(int n, int n2, int n3) {
            this.type = n;
            this.sequence = n2;
            this.site = n3;
        }

        public boolean isStop() {
            return this.type == -1;
        }

        public boolean isIndel() {
            return this.type == -2;
        }

        public int getSequence() {
            return this.sequence;
        }

        public int getSite() {
            return this.site;
        }
    }
}

