/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.InstanceData;

public class SparseInstanceData
implements InstanceData {
    protected double[] attributeValues;
    protected int[] indexValues;
    protected int numberAttributes;

    public SparseInstanceData(double[] attributeValues, int[] indexValues, int numberAttributes) {
        this.attributeValues = attributeValues;
        this.indexValues = indexValues;
        this.numberAttributes = numberAttributes;
    }

    public SparseInstanceData(int length) {
        this.attributeValues = new double[length];
        this.indexValues = new int[length];
    }

    public double[] getAttributeValues() {
        return this.attributeValues;
    }

    public void setAttributeValues(double[] attributeValues) {
        this.attributeValues = attributeValues;
    }

    public int[] getIndexValues() {
        return this.indexValues;
    }

    public void setIndexValues(int[] indexValues) {
        this.indexValues = indexValues;
    }

    public int getNumberAttributes() {
        return this.numberAttributes;
    }

    public void setNumberAttributes(int numberAttributes) {
        this.numberAttributes = numberAttributes;
    }

    @Override
    public int numAttributes() {
        return this.numberAttributes;
    }

    @Override
    public double value(int indexAttribute) {
        int location = this.locateIndex(indexAttribute);
        if (location >= 0 && this.indexValues[location] == indexAttribute) {
            return this.attributeValues[location];
        }
        return 0.0;
    }

    @Override
    public boolean isMissing(int indexAttribute) {
        return Double.isNaN(this.value(indexAttribute));
    }

    @Override
    public int numValues() {
        return this.attributeValues.length;
    }

    @Override
    public int index(int indexAttribute) {
        return this.indexValues[indexAttribute];
    }

    @Override
    public double valueSparse(int indexAttribute) {
        return this.attributeValues[indexAttribute];
    }

    @Override
    public boolean isMissingSparse(int indexAttribute) {
        return Double.isNaN(this.valueSparse(indexAttribute));
    }

    @Override
    public double[] toDoubleArray() {
        double[] array = new double[this.numAttributes()];
        for (int i = 0; i < this.numValues(); ++i) {
            array[this.index((int)i)] = this.valueSparse(i);
        }
        return array;
    }

    @Override
    public void setValue(int attributeIndex, double d) {
        int index = this.locateIndex(attributeIndex);
        if (this.index(index) == attributeIndex) {
            this.attributeValues[index] = d;
        }
    }

    public int locateIndex(int index) {
        int min = 0;
        int max = this.indexValues.length - 1;
        if (max == -1) {
            return -1;
        }
        while (this.indexValues[min] <= index && this.indexValues[max] >= index) {
            int current = (max + min) / 2;
            if (this.indexValues[current] > index) {
                max = current - 1;
                continue;
            }
            if (this.indexValues[current] < index) {
                min = current + 1;
                continue;
            }
            return current;
        }
        if (this.indexValues[max] < index) {
            return max;
        }
        return min - 1;
    }

    @Override
    public void deleteAttributeAt(int position) {
        int index = this.locateIndex(position);
        --this.numberAttributes;
        if (index >= 0 && this.indexValues[index] == position) {
            int[] tempIndices = new int[this.indexValues.length - 1];
            double[] tempValues = new double[this.attributeValues.length - 1];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index);
            System.arraycopy(this.attributeValues, 0, tempValues, 0, index);
            for (int i = index; i < this.indexValues.length - 1; ++i) {
                tempIndices[i] = this.indexValues[i + 1] - 1;
                tempValues[i] = this.attributeValues[i + 1];
            }
            this.indexValues = tempIndices;
            this.attributeValues = tempValues;
        } else {
            int[] tempIndices = new int[this.indexValues.length];
            double[] tempValues = new double[this.attributeValues.length];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index + 1);
            System.arraycopy(this.attributeValues, 0, tempValues, 0, index + 1);
            for (int i = index + 1; i < this.indexValues.length; ++i) {
                tempIndices[i] = this.indexValues[i] - 1;
                tempValues[i] = this.attributeValues[i];
            }
            this.indexValues = tempIndices;
            this.attributeValues = tempValues;
        }
    }

    @Override
    public void insertAttributeAt(int position) {
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        int index = this.locateIndex(position);
        ++this.numberAttributes;
        if (index >= 0 && this.indexValues[index] == position) {
            int[] tempIndices = new int[this.indexValues.length + 1];
            double[] tempValues = new double[this.attributeValues.length + 1];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index);
            System.arraycopy(this.attributeValues, 0, tempValues, 0, index);
            tempIndices[index] = position;
            tempValues[index] = Double.NaN;
            for (int i = index; i < this.indexValues.length; ++i) {
                tempIndices[i + 1] = this.indexValues[i] + 1;
                tempValues[i + 1] = this.attributeValues[i];
            }
            this.indexValues = tempIndices;
            this.attributeValues = tempValues;
        } else {
            int[] tempIndices = new int[this.indexValues.length + 1];
            double[] tempValues = new double[this.attributeValues.length + 1];
            System.arraycopy(this.indexValues, 0, tempIndices, 0, index + 1);
            System.arraycopy(this.attributeValues, 0, tempValues, 0, index + 1);
            tempIndices[index + 1] = position;
            tempValues[index + 1] = Double.NaN;
            for (int i = index + 1; i < this.indexValues.length; ++i) {
                tempIndices[i + 1] = this.indexValues[i] + 1;
                tempValues[i + 1] = this.attributeValues[i];
            }
            this.indexValues = tempIndices;
            this.attributeValues = tempValues;
        }
    }

    @Override
    public InstanceData copy() {
        return new SparseInstanceData((double[])this.attributeValues.clone(), (int[])this.indexValues.clone(), this.numberAttributes);
    }
}

