/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.sliq.AttributeList;
import dmLab.classifier.sliq.ClassList;
import dmLab.classifier.sliq.NominalHistogram;
import dmLab.classifier.sliq.SliqNode;
import dmLab.classifier.sliq.SliqParams;
import dmLab.classifier.sliq.SliqTree;
import dmLab.classifier.sliq.Tree.Node;
import dmLab.classifier.sliq.Tree.Tree;
import dmLab.classifier.sliq.Tree.treePruning.mdlTreePruning.MdlTreePruning;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;

public final class SliqClassifier
extends Classifier {
    private AttributeList[] attributesLists;
    private ClassList classList;
    private int trainAttrNumber;
    private SliqTree sliqTree;
    private FArray trainArray;
    private SliqParams cfg;

    public SliqClassifier() {
        this.label = "sliq";
        this.model = SLIQ;
        this.params = new SliqParams();
        this.cfg = (SliqParams)this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        void var1_1;
        void var2_2;
        this.params.save(path, name);
        FileWriter writer = new FileWriter(path + "//" + (String)var2_2 + ".tree");
        writer.write(((Classifier)this).toString());
        var1_1.close();
        return true;
    }

    @Override
    public final boolean add_RI(AttributesRI[] importances) {
        this.attrSet = new HashSet();
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = QualityMeasure.calcWAcc(this.predResult.confusionMatrix.getMatrix());
        this.sliqTree.addInfo(this.trainArray, this.sliqTree.root$81bb75f, experimentIndicators, importances[0], this.attrSet);
        for (int i = 0; i < importances.length; ++i) {
            importances[i].flushMeasures();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean train(FArray trainArray) {
        this.trainArray = trainArray;
        this.trainSetSize = ((Array)trainArray).rowsNumber();
        FArray fArray = trainArray;
        this.trainAttrNumber = fArray.attributes.length;
        this.attributesLists = new AttributeList[this.trainAttrNumber];
        long start = System.currentTimeMillis();
        this.classList = new ClassList(trainArray);
        int decisionIndex = trainArray.getDecAttrIdx();
        for (int j = 0; j < this.trainAttrNumber; ++j) {
            if (j == decisionIndex) continue;
            this.attributesLists[j] = new AttributeList(trainArray, j);
        }
        this.sliqTree = new SliqTree(this.classList);
        this.sliqTree.setAttributesNumber(this.trainAttrNumber);
        this.classList.initializeClassNodesRefs(this.sliqTree);
        int level = 0;
        this.classList.calcClassFrequencies$2f9c67c6();
        Object object = this.sliqTree;
        this.sliqTree.calcFreqClassGiniPurity(((Tree)object).root$81bb75f, this.classList);
        while (true) {
            int n;
            int n2;
            int n3;
            Object object2;
            Object object3;
            boolean bl;
            int n4;
            int n5;
            block24: {
                object = this.sliqTree;
                n5 = ((SliqTree)object).getLeafsSize();
                for (n4 = 0; n4 < n5; ++n4) {
                    if (((SliqTree)object).getLeaf(n4).getLeafIndicator()) continue;
                    bl = false;
                    break block24;
                }
                bl = true;
            }
            if (bl || level >= this.cfg.maxLevel) break;
            object = this;
            for (n4 = 0; n4 < ((SliqClassifier)object).trainAttrNumber; ++n4) {
                int n6;
                if (((SliqClassifier)object).attributesLists[n4] == null) continue;
                ((SliqClassifier)object).attributesLists[n4].initSplitStatus();
                object3 = ((SliqClassifier)object).attributesLists[n4];
                SliqTree sliqTree = ((SliqClassifier)object).sliqTree;
                object2 = ((SliqClassifier)object).classList;
                int n7 = sliqTree.getLeafsSize();
                if (((AttributeList)object3).getAttrType()) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        SliqNode sliqNode = sliqTree.getLeaf(n6);
                        if (sliqNode.getLeafIndicator()) continue;
                        sliqNode.numericHistogram.init(sliqNode.classFrequencies);
                    }
                } else {
                    for (n6 = 0; n6 < n7; ++n6) {
                        SliqNode sliqNode = sliqTree.getLeaf(n6);
                        if (sliqNode.getLeafIndicator()) continue;
                        sliqNode.nominalHistogram = new NominalHistogram((ClassList)object2, (AttributeList)object3);
                    }
                }
                n3 = ((SliqClassifier)object).attributesLists[n4].getEventsNumber();
                if (((SliqClassifier)object).attributesLists[n4].getAttrType()) {
                    object2 = object;
                    int n8 = ((SliqClassifier)object2).sliqTree.getLeafsSize();
                    for (n5 = 0; n5 < n8; ++n5) {
                        object3 = ((SliqClassifier)object2).sliqTree.getLeaf(n5);
                        if (((Node)object3).getLeafIndicator()) continue;
                        ((SliqNode)object3).tmpInit();
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (((SliqClassifier)object).classList.getAttrValueLeafPurity(((SliqClassifier)object).attributesLists[n4], n2)) continue;
                        n = ((SliqClassifier)object).attributesLists[n4].getAttrProxyIndex(n2);
                        SliqNode sliqNode = ((SliqClassifier)object).classList.getAttrValueLeaf(((SliqClassifier)object).attributesLists[n4], n2);
                        if (sliqNode.tmpSplittingValueProxyIndexEval == -1) {
                            sliqNode.tmpSplittingValueProxyIndexEval = n;
                        }
                        if (sliqNode.tmpSplittingValueProxyIndexEval != n) {
                            float f;
                            float f2 = ((SliqClassifier)object).sliqTree.getGoodnessOfSplit(sliqNode, true);
                            if (f > sliqNode.tmpGoodnessOfSplit) {
                                sliqNode.tmpGoodnessOfSplit = f2;
                                sliqNode.tmpSplittingValueProxyIndex = sliqNode.tmpSplittingValueProxyIndexEval;
                                sliqNode.tmpSplittingValueProxyIndexEval = n;
                            }
                        }
                        ((SliqClassifier)object).classList.updateToLEftAttrValueLeafNumHist(((SliqClassifier)object).attributesLists[n4], n2);
                    }
                    Object object4 = object;
                    super.splitsUpdate(((SliqClassifier)object4).attributesLists[n4], n4, true);
                    continue;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n4 != 9 || n2 != 8083 || ((SliqClassifier)object).classList.getAttrValueLeafPurity(((SliqClassifier)object).attributesLists[n4], n2)) continue;
                    ((SliqClassifier)object).classList.incRightAttrValueLeafNomHist(((SliqClassifier)object).attributesLists[n4], n2);
                }
                Object object5 = object;
                super.splitsUpdate(((SliqClassifier)object5).attributesLists[n4], n4, false);
            }
            object2 = object;
            int n9 = ((SliqClassifier)object2).sliqTree.getLeafsSize();
            for (n5 = 0; n5 < n9; ++n5) {
                object3 = ((SliqClassifier)object2).sliqTree.getLeaf(n5);
                if (((SliqNode)object3).attrListSplittingAttrIndex == -1) continue;
                ((SliqClassifier)object2).attributesLists[((SliqNode)object3).attrListSplittingAttrIndex].setSplitStatus(true);
            }
            this.sliqTree.createLeafs(this.classList);
            FArray fArray2 = trainArray;
            object = this;
            int n10 = ((SliqClassifier)object).sliqTree.getLeafsSize();
            for (n = 0; n < ((SliqClassifier)object).trainAttrNumber; ++n) {
                if (((SliqClassifier)object).attributesLists[n] == null || !((SliqClassifier)object).attributesLists[n].getSplitStatus()) continue;
                int n11 = ((SliqClassifier)object).attributesLists[n].getAllEventsNumber();
                for (n3 = 0; n3 < n11; ++n3) {
                    boolean bl2;
                    SliqNode sliqNode;
                    block25: {
                        n2 = ((SliqClassifier)object).attributesLists[n].getAllAttrClassIndex(n3);
                        sliqNode = ((SliqClassifier)object).classList.getClassLeafRef(n2);
                        if (sliqNode.getLeafIndicator() || sliqNode.attrListSplittingAttrIndex != n) continue;
                        SliqTree cfr_ignored_0 = ((SliqClassifier)object).sliqTree;
                        int n12 = n2;
                        FArray fArray3 = fArray2;
                        SliqNode sliqNode2 = sliqNode;
                        float f = fArray3.readValue(sliqNode2.getSplittingAttrIndex(), n12);
                        float[] fArray4 = sliqNode2.getSplittingValues();
                        if (sliqNode2.getSplittingAttrType()) {
                            bl2 = f <= fArray4[0];
                        } else {
                            int n13 = 0;
                            do {
                                if (f != fArray4[n13]) continue;
                                bl2 = true;
                                break block25;
                            } while (++n13 < fArray4.length);
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        ((SliqClassifier)object).classList.setClassLeafRef(n2, sliqNode.left$81bb75f);
                        continue;
                    }
                    ((SliqClassifier)object).classList.setClassLeafRef(n2, sliqNode.right$81bb75f);
                }
            }
            SliqTree cfr_ignored_1 = ((SliqClassifier)object).sliqTree;
            ((SliqClassifier)object).classList.calcClassFrequencies$2f9c67c6();
            for (n = 0; n < n10; ++n) {
                SliqNode sliqNode = ((SliqClassifier)object).sliqTree.getLeaf(n);
                if (sliqNode.getLeafIndicator()) continue;
                ((SliqClassifier)object).sliqTree.calcFreqClassGiniPurity(sliqNode, ((SliqClassifier)object).classList);
            }
            ++level;
        }
        long stop222 = System.currentTimeMillis();
        this.learningTime = (float)(stop222 - start) / 1000.0f;
        this.sliqTree.setTreeBuildingTime(this.learningTime);
        if (this.cfg.mdlPruning) {
            void var2_5;
            start = System.currentTimeMillis();
            object = this;
            MdlTreePruning stop222 = new MdlTreePruning(((SliqClassifier)object).sliqTree);
            stop222.treePrune();
            long stop222 = System.currentTimeMillis();
            this.learningTime = (float)(stop222 - var2_5) / 1000.0f;
            this.sliqTree.setTreePruningTime(this.learningTime);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_2;
        long start = System.currentTimeMillis();
        this.predResult.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), ((Array)testArray).getDecValuesStr());
        int testEventsNumber = ((Array)testArray).rowsNumber();
        this.predResult.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        for (int i = 0; i < testEventsNumber; ++i) {
            int n = i;
            FArray fArray = testArray;
            SliqClassifier sliqClassifier = this;
            float predictedDecision = sliqClassifier.sliqTree.classifyEvent(fArray, n);
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.predResult.confusionMatrix.add(realDecision, predictedDecision);
            String realClassName = testArray.dictionary.toString(realDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predResult.predictions[i] = new Prediction(realClassName, predictedClassName, null);
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_2) / 1000.0f;
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### Sliq Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        tmp.append(this.sliqTree.toString(this.trainArray, true));
        return var1_1.toString();
    }

    private void splitsUpdate(AttributeList attributeList, int splittingAttrIndex, boolean splittingAttrType) {
        int leafsNumber = this.sliqTree.getLeafsSize();
        if (splittingAttrType) {
            for (int leafIndex = 0; leafIndex < leafsNumber; ++leafIndex) {
                SliqNode node = this.sliqTree.getLeaf(leafIndex);
                if (node.getLeafIndicator() || !(node.tmpGoodnessOfSplit > node.getGoodnessOfSplit())) continue;
                SliqNode sliqNode = node;
                sliqNode.setGoodnessOfSplit(sliqNode.tmpGoodnessOfSplit);
                node.setSplittingAttrIndex(attributeList.getAttrIndex());
                node.attrListSplittingAttrIndex = splittingAttrIndex;
                node.setSplittingAttrType(splittingAttrType);
                float[] fArray = new float[1];
                float[] splittingValues = fArray;
                fArray[0] = attributeList.getAttrProxyValue(node.tmpSplittingValueProxyIndex);
                node.setSplittingValues(splittingValues);
            }
            return;
        }
        for (int leafIndex = 0; leafIndex < leafsNumber; ++leafIndex) {
            SliqNode node = this.sliqTree.getLeaf(leafIndex);
            if (node.getLeafIndicator()) continue;
            float[] splittingValues = this.sliqTree.findBestSubset(node, attributeList);
            if (!(node.tmpGoodnessOfSplit > node.getGoodnessOfSplit())) continue;
            SliqNode sliqNode = node;
            sliqNode.setGoodnessOfSplit(sliqNode.tmpGoodnessOfSplit);
            node.setSplittingAttrIndex(attributeList.getAttrIndex());
            node.attrListSplittingAttrIndex = splittingAttrIndex;
            node.setSplittingAttrType(splittingAttrType);
            node.setSplittingValues(splittingValues);
        }
    }
}

