/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.selector;

import dmLab.array.FArray;
import dmLab.classifier.adx.complex.Quality;
import dmLab.classifier.adx.selector.Selector;
import dmLab.utils.condition.Operator;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public final class SelectorList {
    private Selector[] selectorsArray;
    private HashMap<String, Integer> hashDictionary = new HashMap();
    private int size = 0;
    private int initSize = 1000;
    public boolean verbose = false;

    public SelectorList() {
        this.selectorsArray = new Selector[this.initSize];
    }

    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final int addSelector(Selector selector) {
        void var1_2;
        int newSelectorId22;
        String symbolicSelector = selector.toString();
        if (this.hashDictionary.containsKey(symbolicSelector)) {
            newSelectorId22 = this.hashDictionary.get(symbolicSelector);
        } else {
            void var2_3;
            void newSelectorId22;
            if (this.selectorsArray.length == this.size) {
                SelectorList selectorList = this;
                Selector[] selectorArray = new Selector[selectorList.selectorsArray.length + selectorList.initSize];
                System.arraycopy(selectorList.selectorsArray, 0, selectorArray, 0, selectorList.size);
                selectorList.selectorsArray = selectorArray;
            }
            this.selectorsArray[this.size++] = newSelectorId22;
            newSelectorId22 = this.size - 1;
            this.hashDictionary.put((String)var2_3, newSelectorId22);
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Selector getSelector(int selectorIndex) {
        void var1_1;
        return this.selectorsArray[var1_1];
    }

    public final int createSelectorBase(FArray array, int decisionValIndex) {
        FArray fArray = array;
        int attrNumber = fArray.attributes.length;
        int decAttrIndex = array.getDecAttrIdx();
        for (int i = 0; i < attrNumber; ++i) {
            if (i == decAttrIndex) continue;
            int domainSize = array.getADXDomain(i).size();
            for (int j = 0; j < domainSize; ++j) {
                if (domainSize <= 1 || domainSize == 2 && array.getADXDomain(i).contains(Float.NaN) || !(array.getADXDomain(i).posCoverage(j, decisionValIndex) > 0.0f) || Float.valueOf(array.getADXDomain(i).getValue(j)).isNaN()) continue;
                this.addSelector(new Selector(false, i, new Operator("="), array.getADXDomain(i).getValue(j), array.getADXDomain(i).posCoverage(j, decisionValIndex), array.getADXDomain(i).negCoverage(j, decisionValIndex), array.getADXDomain(i).coverage(j, decisionValIndex), array.getADXDomain(i).posSupport(j, decisionValIndex), array.getADXDomain(i).negSupport(j, decisionValIndex)));
            }
        }
        if (this.verbose) {
            System.out.println("");
        }
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("Selectors: #" + this.size).append('\n');
        int i = 0;
        while (i < this.size) {
            int n = i++;
            SelectorList selectorList = this;
            Selector selector = selectorList.selectorsArray[n];
            tmp.append(selector.toString()).append('\t');
            tmp.append(((Selector)((Object)selectorList)).toStringCov()).append('\n');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void save(String fileName) {
        FileWriter file;
        try {
            file = new FileWriter(fileName + ".sel", false);
        }
        catch (IOException iOException) {
            System.err.println("Error opening file. File: " + fileName + ".sel");
            return;
        }
        try {
            void var2_2;
            int i = 0;
            while (i < this.size) {
                int n = i++;
                SelectorList selectorList = this;
                file.write(selectorList.selectorsArray[n].toString() + '\n');
            }
            var2_2.close();
            return;
        }
        catch (IOException e) {
            void var3_4;
            void var1_1;
            System.err.println("Error writing file. File: " + (String)var1_1 + ".sel");
            var3_4.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void save(String fileName, FArray array) {
        FileWriter file;
        try {
            file = new FileWriter(fileName + ".txt", false);
        }
        catch (IOException iOException) {
            System.err.println("Error opening file. File: " + fileName + ".txt");
            return;
        }
        try {
            void var3_3;
            int i = 0;
            while (i < this.size) {
                int n = i;
                SelectorList selectorList = this;
                StringBuilder stringBuilder = new StringBuilder().append(selectorList.selectorsArray[n].toString(array)).append(" ");
                n = i++;
                selectorList = this;
                file.write(stringBuilder.append(selectorList.selectorsArray[n].toStringCov()).append('\n').toString());
            }
            var3_3.close();
            return;
        }
        catch (IOException e) {
            void var1_1;
            System.err.println("Error writing file. File: " + (String)var1_1 + ".txt");
            e.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteInsignificant(int searchBeam2, int qMethod) {
        void var1_3;
        if (this.size == 0 || searchBeam2 >= this.size) {
            return;
        }
        int n = qMethod;
        int n2 = searchBeam2;
        SelectorList searchBeam2 = this;
        double[] dArray = new double[n2];
        --n2;
        for (int i = 0; i < searchBeam2.size; ++i) {
            double d = Quality.calc(searchBeam2.selectorsArray[i].posCoverage, searchBeam2.selectorsArray[i].negCoverage, n);
            if (n2 > 0) {
                dArray[n2--] = d;
                continue;
            }
            if (!(dArray[0] < d)) continue;
            dArray[0] = d;
            Arrays.sort(dArray);
        }
        if (n2 > 0) {
            Arrays.sort(dArray);
        }
        double significantQ = dArray[n2];
        int notNull = 0;
        for (int i = 0; i < this.size; ++i) {
            if (Quality.calc(this.selectorsArray[i].posCoverage, this.selectorsArray[i].negCoverage, qMethod) < significantQ) {
                this.hashDictionary.remove(this.selectorsArray[i].toString());
                this.selectorsArray[i] = null;
                continue;
            }
            ++notNull;
        }
        Selector[] selectorsArrayTmp = new Selector[(int)Math.ceil((double)notNull / (double)this.initSize) * this.initSize];
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.selectorsArray[i] == null) continue;
            selectorsArrayTmp[j++] = this.selectorsArray[i];
        }
        this.selectorsArray = (Selector[])selectorsArrayTmp.clone();
        this.size = var1_3;
    }
}

