/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.swing.Headless;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.test.TestingFrame;

public class TestingPanel
extends JPanel {
    public static final int width = 600;
    public static final int height = 600;
    protected String[] args;
    protected VectorGraphics graphics;
    protected List<String> names = new ArrayList<String>();
    protected List<JComponent> pages = new ArrayList<JComponent>();

    public TestingPanel(String[] args) throws Exception {
        this.args = args;
        if (args != null && args.length != 0) {
            if (args[0].equals(ImageGraphics2D.class.getName())) {
                if (args.length != 3) {
                    System.err.println("Usage: Test... " + ImageGraphics2D.class + " format OutputFile");
                    System.exit(1);
                }
            } else if (args.length != 2) {
                System.err.println("Usage: Test... VectorGraphicsClassName OutputFile");
                System.exit(1);
            }
        }
    }

    protected void addPage(String name, JComponent c) {
        this.names.add(name);
        this.pages.add(c);
    }

    public void runTest() throws Exception {
        this.runTest(null);
    }

    public void runTest(int width, int height) throws Exception {
        this.runTest(width, height, null);
    }

    public void runTest(Properties options) throws Exception {
        this.runTest(600, 600, options);
    }

    public void runTest(int width, int height, Properties options) throws Exception {
        this.setPreferredSize(new Dimension(width, height));
        if (this.args == null || this.args.length == 0) {
            TestingFrame frame = new TestingFrame(this.getClass().toString());
            if (this.names.size() > 0) {
                for (int i = 0; i < this.names.size(); ++i) {
                    frame.addPanel(this.names.get(i), this.pages.get(i));
                }
                frame.setSize(width, height);
            } else {
                frame.addPanel(this);
                frame.pack();
            }
            frame.setVisible(true);
        } else {
            File file;
            Headless headless = new Headless((JComponent)this);
            headless.pack();
            headless.setVisible(true);
            if (this.args[0].equals(ImageGraphics2D.class.getName())) {
                file = new File(this.args[2]);
                this.graphics = new ImageGraphics2D(file, (Component)this, this.args[1]);
            } else {
                try {
                    file = new File(this.args[1]);
                    Class<?> cls = Class.forName(this.args[0]);
                    Constructor<?> constructor = cls.getConstructor(File.class, Component.class);
                    this.graphics = (VectorGraphics)constructor.newInstance(file, this);
                }
                catch (ClassNotFoundException e) {
                    System.out.println("Cannot find class: " + this.args[0]);
                    throw e;
                }
                catch (ClassCastException e) {
                    System.out.println("Class: " + this.args[0] + " does not extend VectorGraphics");
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    System.out.println("Class: " + this.args[0] + " does not have constructor(File, Component)");
                    throw e;
                }
                catch (InvocationTargetException e) {
                    System.out.println(e.getTargetException());
                    e.getTargetException().printStackTrace();
                    throw e;
                }
            }
            UserProperties user = options == null ? new UserProperties() : new UserProperties(options);
            user.setProperty(".AntialiasText", false);
            this.graphics.setProperties((Properties)user);
            this.graphics.setDeviceIndependent(true);
            this.graphics.startExport();
            this.print((Graphics)this.graphics);
            this.graphics.endExport();
        }
    }
}

