/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.DecompressableInputStream;

public class BitInputStream
extends DecompressableInputStream {
    protected static final int MASK_SIZE = 8;
    protected static final int ZERO = 0;
    protected static final int ONES = -1;
    protected static final int[] BIT_MASK = new int[8];
    protected static final int[] FIELD_MASK = new int[8];
    private int bits = 0;
    private int validBits = 0;

    static {
        int tempBit = 1;
        int tempField = 1;
        int i = 0;
        while (i < 8) {
            BitInputStream.BIT_MASK[i] = tempBit;
            BitInputStream.FIELD_MASK[i] = tempField;
            tempBit <<= 1;
            tempField <<= 1;
            ++tempField;
            ++i;
        }
    }

    public BitInputStream(InputStream in) {
        super(in);
    }

    protected void fetchByte() throws IOException {
        this.bits = this.read();
        if (this.bits < 0) {
            throw new EOFException();
        }
        this.validBits = 8;
    }

    public void byteAlign() {
        this.validBits = 0;
    }

    public boolean readBitFlag() throws IOException {
        if (this.validBits == 0) {
            this.fetchByte();
        }
        return (this.bits & BIT_MASK[--this.validBits]) != 0;
    }

    public long readSBits(int n) throws IOException {
        if (n == 0) {
            return 0L;
        }
        int value = this.readBitFlag() ? -1 : 0;
        return (long)(value <<= --n) | this.readUBits(n);
    }

    public float readFBits(int n) throws IOException {
        if (n == 0) {
            return 0.0f;
        }
        return (float)this.readSBits(n) / 4096.0f;
    }

    public long readUBits(int n) throws IOException {
        long value = 0L;
        while (n > 0) {
            if (this.validBits == 0) {
                this.fetchByte();
            }
            int nbits = n > this.validBits ? this.validBits : n;
            int temp = this.bits >> this.validBits - nbits & FIELD_MASK[nbits - 1];
            this.validBits -= nbits;
            n -= nbits;
            value <<= nbits;
            value |= (long)temp;
        }
        return value;
    }
}

