\name{EM-like algorithms}
\alias{em.step}
\alias{aecm.step}
\alias{apecm.step}
\alias{apecma.step}
\alias{kmeans.step}
\alias{em.step.dmat}
\alias{kmeans.step.dmat}
\title{EM-like Steps for GBD}
\description{
  The EM-like algorithm for model-based clustering of finite mixture Gaussian
  models with unstructured dispersions.

  \code{*.dmat}'s are \code{ddmatrix} versions.
}
\usage{
  em.step(PARAM.org)
  aecm.step(PARAM.org)
  apecm.step(PARAM.org)
  apecma.step(PARAM.org)
  kmeans.step(PARAM.org)

  em.step.dmat(PARAM.org)
  kmeans.step.dmat(PARAM.org)
}
\arguments{
  \item{PARAM.org}{an original set of parameters generated
                   by \code{\link{set.global}}.}
}
\details{
  A global variable called \code{\link{X.spmd}} should exist in the
  \code{\link{.pmclustEnv}}
  environment, usually the working environment. The \code{\link{X.spmd}}
  is the data matrix to be clustered, and this matrix has a dimension
  \code{N.spmd} by \code{p}.

  A \code{PARAM.org} will be a local variable inside all EM-linke functions
  \code{\link{em.step}}, \code{\link{aecm.step}},
  \code{\link{apecm.step}}, \code{\link{apecma.step}}, and
  \code{\link{kmeans.step}},
  This variable is a list containing all parameters related to models.
  This function also updates in the parameters by the EM-like algorithms, and
  return the convergent results. The details of list elements are initially
  generated by \code{\link{set.global}}.
}
\value{
  A convergent results will be returned the other list variable
  containing all new parameters which represent the components of models.
  See the help page of \code{\link{PARAM}} or \code{\link{PARAM.org}}
  for details.
}
\references{
  Programming with Big Data in R Website:
  \url{https://pbdr.org/}

  Chen, W.-C. and Maitra, R. (2011)
  \dQuote{Model-based clustering of regression time series data via
          APECM -- an AECM algorithm sung to an even faster beat},
  \emph{Statistical Analysis and Data Mining},
  \bold{4}, 567-578.

  Chen, W.-C., Ostrouchov, G., Pugmire, D., Prabhat, M., and Wehner, M. (2013)
  \dQuote{A Parallel EM Algorithm for Model-Based Clustering with
          Application to Explore Large Spatio-Temporal Data},
  \emph{Technometrics},
  (revision).

  Dempster, A.P., Laird, N.M. and Rubin, D.B. (1977)
  \dQuote{Maximum Likelihood from Incomplete Data via the EM Algorithm},
  \emph{Journal of the Royal Statistical Society Series B},
  \bold{39}, 1-38.

  Lloyd., S. P. (1982)
  \dQuote{Least squares quantization in PCM},
  \emph{IEEE Transactions on Information Theory},
  \bold{28}, 129-137.

  Meng, X.-L. and Van Dyk, D. (1997)
  \dQuote{The EM Algorithm.an Old Folk-song Sung to a Fast New Tune},
  \emph{Journal of the Royal Statistical Society Series B},
  \bold{59}, 511-567.
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{mb.print}},
  \code{\link{set.global.dmat}}.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run in 4 processors by
# > mpiexec -np 4 Rscript demo.r

### Setup environment.
library(pmclust, quiet = TRUE)
comm.set.seed(123)

### Generate an example data.
N.allspmds <- rep(5000, comm.size())
N.spmd <- 5000
N.K.spmd <- c(2000, 3000)
N <- 5000 * comm.size()
p <- 2
K <- 2
data.spmd <- generate.basic(N.allspmds, N.spmd, N.K.spmd, N, p, K)
X.spmd <- data.spmd$X.spmd

### Run clustering.
PARAM.org <- set.global(K = K)          # Set global storages.
# PARAM.org <- initial.em(PARAM.org)    # One initial.
PARAM.org <- initial.RndEM(PARAM.org)   # Ten initials by default.
PARAM.new <- apecma.step(PARAM.org)     # Run APECMa.
em.update.class()                       # Get classification.

### Get results.
N.CLASS <- get.N.CLASS(K)
comm.cat("# of class:", N.CLASS, "\n")

### Quit.
finalize()
}
}
\keyword{algorithm}

