## ----echo = FALSE, message = FALSE--------------------------------------------
knitr::opts_chunk$set(collapse = T, comment = "#>")

## ----message = FALSE, warning=FALSE-------------------------------------------
library(FactoMineR)
library(booklet)
data(decathlon)

## -----------------------------------------------------------------------------
# Get eigvalues and eigvectors with FactoMineR
X <- decathlon[, -c(11:13)]
res_pca <- PCA(X, quanti.sup = 10, ind.sup = 1, graph = FALSE)
head(res_pca$eig)

## -----------------------------------------------------------------------------
# Get eigvalues and eigvectors with booklet
X_active <- X[-1, -10]
X_active_scaled <- pca_standardize(X_active, scale = TRUE)

eigs <- pca_weighted_eigen(X_active_scaled)

df_eigs <- data.frame(
  eigenvalue = eigs$values,
  `percentage of variance` = eigs$values / sum(eigs$values) * 100,
  `cumulative percentage of variance` = cumsum(eigs$values / sum(eigs$values)) * 100
)

rownames(df_eigs) <- paste0("comp ", 1:nrow(df_eigs))

df_eigs |> head()

## -----------------------------------------------------------------------------
# Get principal components with FactoMineR
head(res_pca$ind$coord)

## -----------------------------------------------------------------------------
# Get principal components with booklet
ind_coords <- pca_ind_coords(eigs)
head(ind_coords[, 1:5])

## -----------------------------------------------------------------------------
# Get individual cos2 with FactoMineR
head(res_pca$ind$cos2)

## -----------------------------------------------------------------------------
# Get individual cos2 with booklet
ind_cos2 <- pca_ind_cos2(ind_coords)
head(ind_cos2[, 1:5])

## -----------------------------------------------------------------------------
# Get individual contributions with FactoMineR
head(res_pca$ind$contrib)

## -----------------------------------------------------------------------------
# Get individual contributions with booklet
ind_contrib <- pca_ind_contrib(ind_coords, eigs)
head(ind_contrib[, 1:5])

## -----------------------------------------------------------------------------
# Get supplementary individuals with FactoMineR
res_pca$ind.sup$coord

## -----------------------------------------------------------------------------
# Get supplementary individuals with booklet
weights <- rep(1, nrow(X_active)) / nrow(X_active)
center <- colMeans(X_active)
std <- sqrt(as.vector(crossprod(weights, as.matrix(X_active^2)) - center^2))

X_sup <- X[1, -10]
X_sup_scaled <- (X_sup - center) / std
ind_sup_coords <- as.data.frame(as.matrix(X_sup_scaled) %*% eigs$vectors)
rownames(ind_sup_coords) <- rownames(X_sup)
ind_sup_coords[, 1:5]

## -----------------------------------------------------------------------------
# Get supplementary individuals cos2 with FactoMineR
res_pca$ind.sup$cos2

## -----------------------------------------------------------------------------
# Get supplementary individuals cos2 with booklet
ind_sup_cos2 <- pca_ind_cos2(ind_sup_coords)
ind_sup_cos2[, 1:5]

## -----------------------------------------------------------------------------
# Get variable coordinates with FactoMineR
head(res_pca$var$coord)

## -----------------------------------------------------------------------------
# Get variable coordinates with booklet
var_coords <- pca_var_coords(eigs)
head(var_coords[, 1:5])

## -----------------------------------------------------------------------------
# Get variable cos2 with FactoMineR
head(res_pca$var$cos2)

## -----------------------------------------------------------------------------
# Get variable cos2 with booklet
var_cos2 <- pca_var_cos2(var_coords)
head(var_cos2[, 1:5])

## -----------------------------------------------------------------------------
# Get variable contributions with FactoMineR
head(res_pca$var$contrib)

## -----------------------------------------------------------------------------
# Get variable contributions with booklet
var_contrib <- pca_var_contrib(var_cos2, eigs)
head(var_contrib[, 1:5])

## -----------------------------------------------------------------------------
# Get supplementary variables coordinates with FactoMineR
res_pca$quanti.sup$coord

## -----------------------------------------------------------------------------
# Get supplementary CONTINUOUS variables coordinates with booklet
X_sup <- X[-1, 10, drop = FALSE]
X_sup_scaled <- pca_standardize(X_sup, scale = TRUE)

var_sup_coords <- as.data.frame(t(X_sup_scaled * weights) %*% eigs$U)
rownames(var_sup_coords) <- colnames(X_sup)
var_sup_coords[, 1:5]

## -----------------------------------------------------------------------------
# Get supplementary variables cos2 with FactoMineR
res_pca$quanti.sup$cos2

## -----------------------------------------------------------------------------
# Get supplementary variables cos2 with booklet
var_sup_cos2 <- pca_var_cos2(var_sup_coords)
var_sup_cos2[, 1:5]

