/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.SimpleCOD;

import java.util.Vector;
import moa.clusterers.outliers.SimpleCOD.ISBIndex;
import moa.clusterers.outliers.SimpleCOD.SimpleCODBase;
import moa.clusterers.outliers.SimpleCOD.StreamObj;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class SimpleCOD
extends SimpleCODBase {
    public FloatOption radiusOption = new FloatOption("radius", 'r', "Search radius.", 0.1);
    public IntOption kOption = new IntOption("k", 't', "Parameter k.", 50);

    public void Init() {
        super.Init();
        this.m_WindowSize = this.windowSizeOption.getValue();
        this.m_radius = this.radiusOption.getValue();
        this.m_k = this.kOption.getValue();
        this.Println("Init SimpleCOD:");
        this.Println("   window_size: " + this.m_WindowSize);
        this.Println("   radius: " + this.m_radius);
        this.Println("   k: " + this.m_k);
        this.objId = FIRST_OBJ_ID;
        this.windowNodes = new Vector();
        this.ISB = new ISBIndex(this.m_radius, this.m_k);
        this.eventQueue = new SimpleCODBase.EventQueue();
        this.m_nBothInlierOutlier = 0;
        this.m_nOnlyInlier = 0;
        this.m_nOnlyOutlier = 0;
    }

    void ProcessNewNode(ISBIndex.ISBNode nodeNew, boolean bNewNode) {
        int count;
        if (this.bTrace) {
            this.Print("ProcessNewNode: ");
            this.PrintNode(nodeNew);
        }
        if (this.bTrace) {
            this.Println("Perform R range query");
        }
        ++this.nRangeQueriesExecuted;
        Vector<ISBIndex.ISBSearchResult> resultNodes = this.ISB.RangeSearch(nodeNew, this.m_radius);
        for (ISBIndex.ISBSearchResult sr : resultNodes) {
            int count2;
            double distance = sr.distance;
            ISBIndex.ISBNode q = sr.node;
            if (nodeNew == q || !(distance <= this.m_radius)) continue;
            if (this.bTrace) {
                this.Println("nodeNew has neighbor q.id " + q.id);
            }
            nodeNew.AddPrecNeigh(q);
            ++q.count_after;
            if (!q.bOutlier || (count2 = q.CountPrecNeighs(this.GetWindowStart()) + q.count_after) < this.m_k) continue;
            if (this.bTrace) {
                this.Println("q.id " + q.id + " is now an inlier");
            }
            q.bOutlier = false;
            this.RemoveOutlier(q);
            ISBIndex.ISBNode nodeMinExp = q.GetMinPrecNeigh(this.GetWindowStart());
            this.AddToEventQueue(q, nodeMinExp);
        }
        if (this.bTrace) {
            this.Println("Check if nodeNew is an inlier or outlier");
        }
        if ((count = nodeNew.CountPrecNeighs(this.GetWindowStart()) + nodeNew.count_after) >= this.m_k) {
            if (this.bTrace) {
                this.Println("nodeNew is an inlier");
            }
            nodeNew.bOutlier = false;
            this.RemoveOutlier(nodeNew);
            ISBIndex.ISBNode nodeMinExp = nodeNew.GetMinPrecNeigh(this.GetWindowStart());
            this.AddToEventQueue(nodeNew, nodeMinExp);
        } else {
            if (this.bTrace) {
                this.Println("nodeNew is an outlier");
            }
            nodeNew.bOutlier = true;
            this.SaveOutlier(nodeNew);
        }
    }

    void AddToEventQueue(ISBIndex.ISBNode x, ISBIndex.ISBNode nodeMinExp) {
        if (this.bTrace) {
            this.Println("AddToEventQueue x.id: " + x.id);
        }
        if (nodeMinExp != null) {
            Long expTime = this.GetExpirationTime(nodeMinExp);
            this.eventQueue.Insert(x, expTime);
            if (this.bTrace) {
                this.Print("x.nn_before: ");
                this.PrintNodeList(x.Get_nn_before());
                this.Println("nodeMinExp: " + nodeMinExp.id + ", expTime = " + expTime);
                this.PrintEventQueue();
            }
        } else if (this.bWarning) {
            this.Println("AddToEventQueue: Cannot add x.id: " + x.id + " to event queue (nn_before is empty, count_after=" + x.count_after + ")");
        }
    }

    void ProcessEventQueue(ISBIndex.ISBNode nodeExpired) {
        SimpleCODBase.EventItem e = this.eventQueue.FindMin();
        while (e != null && e.timeStamp <= this.GetWindowEnd()) {
            e = this.eventQueue.ExtractMin();
            ISBIndex.ISBNode x = e.node;
            if (this.bTrace) {
                this.Println("Process event queue: check node x: " + x.id);
            }
            if (this.IsNodeIdInWin(x.id)) {
                x.RemovePrecNeigh(nodeExpired);
                int count = x.count_after + x.CountPrecNeighs(this.GetWindowStart());
                if (count < this.m_k) {
                    if (this.bTrace) {
                        this.Println("x is an outlier");
                    }
                    x.bOutlier = true;
                    this.SaveOutlier(x);
                } else {
                    if (this.bTrace) {
                        this.Println("x is an inlier, add to event queue");
                    }
                    x.bOutlier = false;
                    ISBIndex.ISBNode nodeMinExp = x.GetMinPrecNeigh(this.GetWindowStart());
                    this.AddToEventQueue(x, nodeMinExp);
                }
            } else if (this.bWarning) {
                this.Println("Process event queue: node x.id: " + x.id + " has expired!");
            }
            e = this.eventQueue.FindMin();
        }
    }

    void ProcessExpiredNode(ISBIndex.ISBNode nodeExpired) {
        if (nodeExpired != null) {
            if (this.bTrace) {
                this.Println("\nnodeExpired: " + nodeExpired.id);
            }
            this.ISB.Remove(nodeExpired);
            this.RemoveNode(nodeExpired);
            this.ProcessEventQueue(nodeExpired);
        }
    }

    protected void ProcessNewStreamObj(Instance inst) {
        if (this.bShowProgress) {
            this.ShowProgress("Processed " + (this.objId - 1L) + " stream objects.");
        }
        double[] values = this.getInstanceValues(inst);
        StreamObj obj = new StreamObj(values);
        if (this.bTrace) {
            this.Println("\n- - - - - - - - - - - -\n");
        }
        ISBIndex.ISBNode nodeNew = new ISBIndex.ISBNode(inst, obj, this.objId);
        if (this.bTrace) {
            this.Print("New node: ");
            this.PrintNode(nodeNew);
        }
        Long l = this.objId;
        Long l2 = this.objId = Long.valueOf(this.objId + 1L);
        this.AddNode(nodeNew);
        if (this.bTrace) {
            this.PrintWindow();
        }
        this.ISB.Insert(nodeNew);
        this.ProcessNewNode(nodeNew, true);
        this.ProcessExpiredNode(this.GetExpiredNode());
        if (this.bTrace) {
            this.PrintOutliers();
            this.PrintISB();
        }
    }
}

