/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Slipper;

import keel.Algorithms.Rule_Learning.Slipper.Pair;
import keel.Algorithms.Rule_Learning.Slipper.Trio;

public class Utilities {
    public static double SMALL = 1.0E-6;
    public static double log2 = Math.log(2.0);

    public static void mergeSort(long[] theArray, int nElems) {
        long[] workSpace = new long[nElems];
        Utilities.recMergeSort(theArray, workSpace, 0, nElems - 1);
    }

    private static void recMergeSort(long[] theArray, long[] workSpace, int lowerBound, int upperBound) {
        if (lowerBound == upperBound) {
            return;
        }
        int mid = (lowerBound + upperBound) / 2;
        Utilities.recMergeSort(theArray, workSpace, lowerBound, mid);
        Utilities.recMergeSort(theArray, workSpace, mid + 1, upperBound);
        Utilities.merge(theArray, workSpace, lowerBound, mid + 1, upperBound);
    }

    private static void merge(long[] theArray, long[] workSpace, int lowPtr, int highPtr, int upperBound) {
        int j = 0;
        int lowerBound = lowPtr;
        int mid = highPtr - 1;
        int n = upperBound - lowerBound + 1;
        while (lowPtr <= mid && highPtr <= upperBound) {
            if (theArray[lowPtr] < theArray[highPtr]) {
                workSpace[j++] = theArray[lowPtr++];
                continue;
            }
            workSpace[j++] = theArray[highPtr++];
        }
        while (lowPtr <= mid) {
            workSpace[j++] = theArray[lowPtr++];
        }
        while (highPtr <= upperBound) {
            workSpace[j++] = theArray[highPtr++];
        }
        for (j = 0; j < n; ++j) {
            theArray[lowerBound + j] = workSpace[j];
        }
    }

    public static void mergeSort(Pair[] theArray, int nElems) {
        Pair[] workSpace = new Pair[nElems];
        Utilities.recMergeSort(theArray, workSpace, 0, nElems - 1);
    }

    private static void recMergeSort(Pair[] theArray, Pair[] workSpace, int lowerBound, int upperBound) {
        if (lowerBound == upperBound) {
            return;
        }
        int mid = (lowerBound + upperBound) / 2;
        Utilities.recMergeSort(theArray, workSpace, lowerBound, mid);
        Utilities.recMergeSort(theArray, workSpace, mid + 1, upperBound);
        Utilities.merge(theArray, workSpace, lowerBound, mid + 1, upperBound);
    }

    private static void merge(Pair[] theArray, Pair[] workSpace, int lowPtr, int highPtr, int upperBound) {
        int j = 0;
        int lowerBound = lowPtr;
        int mid = highPtr - 1;
        int n = upperBound - lowerBound + 1;
        while (lowPtr <= mid && highPtr <= upperBound) {
            if (theArray[lowPtr].value < theArray[highPtr].value) {
                workSpace[j++] = theArray[lowPtr++];
                continue;
            }
            workSpace[j++] = theArray[highPtr++];
        }
        while (lowPtr <= mid) {
            workSpace[j++] = theArray[lowPtr++];
        }
        while (highPtr <= upperBound) {
            workSpace[j++] = theArray[highPtr++];
        }
        for (j = 0; j < n; ++j) {
            theArray[lowerBound + j] = workSpace[j];
        }
    }

    public static void mergeSort(Trio[] theArray, int nElems) {
        Trio[] workSpace = new Trio[nElems];
        Utilities.recMergeSort(theArray, workSpace, 0, nElems - 1);
    }

    private static void recMergeSort(Trio[] theArray, Trio[] workSpace, int lowerBound, int upperBound) {
        if (lowerBound == upperBound) {
            return;
        }
        int mid = (lowerBound + upperBound) / 2;
        Utilities.recMergeSort(theArray, workSpace, lowerBound, mid);
        Utilities.recMergeSort(theArray, workSpace, mid + 1, upperBound);
        Utilities.merge(theArray, workSpace, lowerBound, mid + 1, upperBound);
    }

    private static void merge(Trio[] theArray, Trio[] workSpace, int lowPtr, int highPtr, int upperBound) {
        int j = 0;
        int lowerBound = lowPtr;
        int mid = highPtr - 1;
        int n = upperBound - lowerBound + 1;
        while (lowPtr <= mid && highPtr <= upperBound) {
            if (theArray[lowPtr].getKey() < theArray[highPtr].getKey()) {
                workSpace[j++] = theArray[lowPtr++];
                continue;
            }
            workSpace[j++] = theArray[highPtr++];
        }
        while (lowPtr <= mid) {
            workSpace[j++] = theArray[lowPtr++];
        }
        while (highPtr <= upperBound) {
            workSpace[j++] = theArray[highPtr++];
        }
        for (j = 0; j < n; ++j) {
            theArray[lowerBound + j] = workSpace[j];
        }
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < SMALL;
    }

    public static double log2(double a) {
        return Math.log(a) / log2;
    }
}

