/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;

public class GraphExtract {
    protected final TripleBoundary b;

    public GraphExtract(TripleBoundary b) {
        this.b = b;
    }

    public Graph extract(Node node, Graph graph) {
        return this.extractInto(Factory.createGraphMem(), node, graph);
    }

    public Graph extractInto(Graph toUpdate, Node root, Graph extractFrom) {
        new Extraction(this.b, toUpdate, extractFrom).extractInto(root);
        return toUpdate;
    }

    protected static class Extraction {
        protected Graph toUpdate;
        protected Graph extractFrom;
        protected Set active;
        protected TripleBoundary b;

        Extraction(TripleBoundary b, Graph toUpdate, Graph extractFrom) {
            this.toUpdate = toUpdate;
            this.extractFrom = extractFrom;
            this.active = CollectionFactory.createHashedSet();
            this.b = b;
        }

        public void extractInto(Node root) {
            this.active.add(root);
            ExtendedIterator it = this.extractFrom.find(root, Node.ANY, Node.ANY);
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                Node subRoot = t.getObject();
                this.toUpdate.add(t);
                if (this.active.contains(subRoot) || this.b.stopAt(t)) continue;
                this.extractInto(subRoot);
            }
        }
    }
}

