/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.data.Values;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DomainConverter;
import ec.tstoolkit.timeseries.IDomain;
import ec.tstoolkit.timeseries.IPeriod;
import ec.tstoolkit.timeseries.TsAggregationType;

public class GeneralTsData {
    private IDomain m_domain;
    private Values m_vals;

    public GeneralTsData() {
    }

    public GeneralTsData(GeneralTsData ts) {
        if (ts.m_domain != null) {
            this.m_domain = ts.m_domain;
        }
        if (ts.m_vals != null) {
            this.m_vals = new Values(ts.m_vals);
        }
    }

    public GeneralTsData(IDomain dom) {
        this.m_domain = dom;
        this.m_vals = new Values(dom.getLength());
    }

    public GeneralTsData(IDomain dom, double[] vals) {
        this.m_domain = dom;
        this.m_vals = new Values(vals);
    }

    private Values average(DomainConverter converter) {
        int n = converter.getNewDomain().getLength();
        Values vals = new Values(n);
        for (int i = 0; i < n; ++i) {
            int j0 = converter.startPos(i);
            int j1 = converter.endPos(i);
            int m = 0;
            double s = 0.0;
            for (int j = j0; j < j1; ++j) {
                double v = this.m_vals.get(j);
                if (Double.isNaN(v)) continue;
                ++m;
                s += v;
            }
            if (m == 0) continue;
            vals.set(i, s / (double)m);
        }
        return vals;
    }

    protected Object clone() {
        return new GeneralTsData(this);
    }

    public GeneralTsData convert(IDomain newdom, TsAggregationType conv) {
        DomainConverter converter = new DomainConverter();
        if (!converter.convert(newdom, this.m_domain)) {
            return null;
        }
        Values vals = null;
        switch (conv) {
            case Average: {
                vals = this.average(converter);
                break;
            }
            case Sum: {
                vals = this.sum(converter);
                break;
            }
            case First: {
                vals = this.first(converter);
                break;
            }
            case Last: {
                vals = this.last(converter);
                break;
            }
            case Max: {
                vals = this.max(converter);
                break;
            }
            case Min: {
                vals = this.min(converter);
            }
        }
        if (vals != null) {
            GeneralTsData ts = new GeneralTsData();
            ts.m_domain = newdom;
            ts.m_vals = vals;
            return ts;
        }
        return null;
    }

    private Values first(DomainConverter converter) {
        int n = converter.getNewDomain().getLength();
        Values vals = new Values(n);
        block0: for (int i = 0; i < n; ++i) {
            int j0 = converter.startPos(i);
            int j1 = converter.endPos(i);
            for (int j = j0; j < j1; ++j) {
                double v = this.m_vals.get(j);
                if (Double.isNaN(v)) continue;
                vals.set(i, v);
                continue block0;
            }
        }
        return vals;
    }

    public double get(int idx) {
        return this.m_vals.get(idx);
    }

    public IDomain getDomain() {
        return this.m_domain;
    }

    public double getValue(Day day) {
        int idx = this.m_domain.search(day);
        if (idx >= 0) {
            return this.m_vals.get(idx);
        }
        return Double.NaN;
    }

    public double getValue(IPeriod p) {
        Day fd = p.firstday();
        int idx = this.m_domain.search(fd);
        if (idx < 0) {
            return Double.NaN;
        }
        IPeriod pdom = this.m_domain.get(idx);
        if (pdom.firstday() != fd) {
            return Double.NaN;
        }
        Day ld = p.lastday();
        if (pdom.lastday() != ld) {
            return Double.NaN;
        }
        return this.m_vals.get(idx);
    }

    public Values getValues() {
        return this.m_vals;
    }

    private Values last(DomainConverter converter) {
        int n = converter.getNewDomain().getLength();
        Values vals = new Values(n);
        block0: for (int i = 0; i < n; ++i) {
            int j0 = converter.startPos(i);
            int j1 = converter.endPos(i);
            for (int j = j1 - 1; j >= j0; --j) {
                double v = this.m_vals.get(j);
                if (Double.isNaN(v)) continue;
                vals.set(i, v);
                continue block0;
            }
        }
        return vals;
    }

    private Values max(DomainConverter converter) {
        int n = converter.getNewDomain().getLength();
        Values vals = new Values(n);
        for (int i = 0; i < n; ++i) {
            int j0 = converter.startPos(i);
            int j1 = converter.endPos(i);
            double m = Double.NaN;
            for (int j = j1 - 1; j >= j0; --j) {
                double v = this.m_vals.get(j);
                if (Double.isNaN(v) || !Double.isNaN(m) && !(v > m)) continue;
                m = v;
            }
            if (Double.isNaN(m)) continue;
            vals.set(i, m);
        }
        return vals;
    }

    private Values min(DomainConverter converter) {
        int n = converter.getNewDomain().getLength();
        Values vals = new Values(n);
        for (int i = 0; i < n; ++i) {
            int j0 = converter.startPos(i);
            int j1 = converter.endPos(i);
            double m = Double.NaN;
            for (int j = j1 - 1; j >= j0; --j) {
                double v = this.m_vals.get(j);
                if (Double.isNaN(v) || !Double.isNaN(m) && !(v < m)) continue;
                m = v;
            }
            if (Double.isNaN(m)) continue;
            vals.set(i, m);
        }
        return vals;
    }

    public void set(Day day, double value) {
        this.m_vals.set(this.m_domain.search(day), value);
    }

    public void set(int idx, double value) {
        this.m_vals.set(idx, value);
    }

    private Values sum(DomainConverter converter) {
        int n = converter.getNewDomain().getLength();
        Values vals = new Values(n);
        for (int i = 0; i < n; ++i) {
            int j0 = converter.startPos(i);
            int j1 = converter.endPos(i);
            double s = 0.0;
            boolean ok = false;
            for (int j = j0; j < j1; ++j) {
                double v = this.m_vals.get(j);
                if (Double.isNaN(v)) continue;
                ok = true;
                s += v;
            }
            if (!ok) continue;
            vals.set(i, s);
        }
        return vals;
    }
}

