/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.minpack;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.minpack.IEstimationProblem;

public class SsqEstimationProblem
implements IEstimationProblem {
    private ISsqFunction m_fn;
    private DataBlock m_p;
    private ISsqFunctionInstance m_ftry;
    private ISsqFunctionDerivatives m_derivatives;

    public SsqEstimationProblem(ISsqFunction fn, IReadDataBlock start) {
        this(fn, fn.ssqEvaluate(start));
    }

    public SsqEstimationProblem(ISsqFunction fn, ISsqFunctionInstance start) {
        this.m_fn = fn;
        this.m_ftry = start;
        IReadDataBlock p = start.getParameters();
        this.m_p = new DataBlock(p.getLength());
        p.copyTo(this.m_p.getData(), 0);
    }

    @Override
    public void bound(int idx, boolean bound) {
        throw new FunctionException("The method or operation is not implemented.");
    }

    private void calc() {
        this.m_fn.getDomain().validate(this.m_p);
        try {
            this.m_ftry = this.m_fn.ssqEvaluate(this.m_p);
        }
        catch (Exception err) {
            this.m_ftry = null;
        }
    }

    private void clear() {
        this.m_derivatives = null;
        this.m_ftry = null;
    }

    @Override
    public double getMeasurementParialDerivative(int midx, int pidx) {
        if (this.m_ftry == null) {
            this.calc();
        }
        if (this.m_ftry == null) {
            return Math.sqrt(Double.MAX_VALUE);
        }
        if (this.m_derivatives == null) {
            this.m_derivatives = this.m_fn.getDerivatives(this.m_ftry);
        }
        return -this.m_derivatives.dEdX(pidx)[midx];
    }

    @Override
    public int getMeasurementsCount() {
        if (this.m_ftry == null) {
            this.calc();
        }
        return this.m_ftry == null ? 0 : this.m_ftry.getE().length;
    }

    @Override
    public double getMeasurementValue(int idx) {
        if (this.m_ftry == null) {
            this.calc();
        }
        return this.m_ftry == null ? Math.sqrt(Double.MAX_VALUE) : this.m_ftry.getE()[idx];
    }

    @Override
    public double getMeasurementWheight(int idx) {
        return 1.0;
    }

    @Override
    public double getParameterEstimate(int idx) {
        return this.m_p.get(idx);
    }

    @Override
    public int getParametersCount() {
        return this.m_p.getLength();
    }

    @Override
    public double getResidual(int midx) {
        if (this.m_ftry == null) {
            this.calc();
        }
        return this.m_ftry == null ? Math.sqrt(Double.MAX_VALUE) : this.m_ftry.getE()[midx];
    }

    public ISsqFunctionInstance getResult() {
        if (this.m_ftry == null) {
            this.calc();
        }
        return this.m_ftry;
    }

    @Override
    public double getTheoreticalValue(int midx) {
        return 0.0;
    }

    @Override
    public double getUnboundParameterEstimate(int idx) {
        return this.m_p.get(idx);
    }

    @Override
    public int getUnboundParametersCount() {
        return this.m_p.getLength();
    }

    @Override
    public void ignoreMeasurement(int idx, boolean ignore) {
    }

    @Override
    public boolean isBound(int idx) {
        return false;
    }

    @Override
    public boolean isMeasurementIgnore(int idx) {
        return false;
    }

    @Override
    public void setParameterEstimate(int idx, double val) {
        if (this.m_p.get(idx) != val) {
            this.m_p.set(idx, val);
            this.clear();
        }
    }

    @Override
    public void setUnboundParameterEstimate(int idx, double val) {
        if (this.m_p.get(idx) != val) {
            this.m_p.set(idx, val);
            this.clear();
        }
    }

    public double[] getGradient() {
        if (this.m_ftry == null) {
            this.calc();
        }
        if (this.m_ftry == null) {
            return null;
        }
        return this.m_fn.getDerivatives(this.m_ftry).getGradient();
    }
}

