/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list;

import cern.colt.matrix.DoubleMatrix1D;
import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.TallyStore;
import umontreal.iro.lecuyer.stat.list.ListOfTallies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfTalliesWithCovariance<E extends Tally>
extends ListOfTallies<E> {
    private double[] tempArray;
    private double[][] sxy;
    private boolean isStable = true;
    private double[] curAverages;
    private double[][] curSum2;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat.list");

    public ListOfTalliesWithCovariance() {
    }

    public ListOfTalliesWithCovariance(String string) {
        super(string);
    }

    public static ListOfTalliesWithCovariance<Tally> createWithTally(int n) {
        ListOfTalliesWithCovariance<Tally> listOfTalliesWithCovariance = new ListOfTalliesWithCovariance<Tally>();
        for (int i = 0; i < n; ++i) {
            listOfTalliesWithCovariance.add(new Tally());
        }
        listOfTalliesWithCovariance.init();
        return listOfTalliesWithCovariance;
    }

    public static ListOfTalliesWithCovariance<TallyStore> createWithTallyStore(int n) {
        ListOfTalliesWithCovariance<TallyStore> listOfTalliesWithCovariance = new ListOfTalliesWithCovariance<TallyStore>();
        for (int i = 0; i < n; ++i) {
            listOfTalliesWithCovariance.add(new TallyStore());
        }
        listOfTalliesWithCovariance.init();
        return listOfTalliesWithCovariance;
    }

    private void createSxy() {
        int n = this.size();
        if (this.isStable) {
            this.curAverages = new double[n];
            this.curSum2 = new double[n - 1][];
            for (int i = 0; i < n - 1; ++i) {
                this.curSum2[i] = new double[n - 1 - i];
            }
        } else {
            this.sxy = new double[n - 1][];
            for (int i = 0; i < n - 1; ++i) {
                this.sxy[i] = new double[n - 1 - i];
            }
        }
        this.tempArray = new double[n];
    }

    @Override
    public void init() {
        super.init();
        if (this.isModifiable()) {
            this.setUnmodifiable();
            this.createSxy();
        }
        if (this.isStable) {
            int n;
            for (n = 0; n < this.curAverages.length; ++n) {
                this.curAverages[n] = 0.0;
            }
            for (n = 0; n < this.curSum2.length; ++n) {
                for (int i = 0; i < this.curSum2[n].length; ++i) {
                    this.curSum2[n][i] = 0.0;
                }
            }
        } else {
            for (int i = 0; i < this.sxy.length; ++i) {
                for (int j = 0; j < this.sxy[i].length; ++j) {
                    this.sxy[i][j] = 0.0;
                }
            }
        }
    }

    @Override
    public void add(double[] dArray) {
        int n = this.size();
        int n2 = 0;
        int n3 = n2 = this.isStable ? this.curSum2.length : this.sxy.length;
        if (n2 != n - 1) {
            throw new IllegalArgumentException("The structure's size mismatches the list's size");
        }
        super.add(dArray);
        if (this.isStable) {
            int n4;
            int n5 = ((Tally)this.get(0)).numberObs();
            for (n4 = 0; n4 < n - 1; ++n4) {
                for (int i = n4 + 1; i < n; ++i) {
                    double[] dArray2 = this.curSum2[n4];
                    int n6 = i - n4 - 1;
                    dArray2[n6] = dArray2[n6] + (double)(n5 - 1) * (dArray[n4] - this.curAverages[n4]) * (dArray[i] - this.curAverages[i]) / (double)n5;
                }
            }
            for (n4 = 0; n4 < n; ++n4) {
                int n7 = n4;
                this.curAverages[n7] = this.curAverages[n7] + (dArray[n4] - this.curAverages[n4]) / (double)n5;
            }
        } else {
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    double[] dArray3 = this.sxy[i];
                    int n8 = j - i - 1;
                    dArray3[n8] = dArray3[n8] + dArray[i] * dArray[j];
                }
            }
        }
    }

    public void add(DoubleMatrix1D doubleMatrix1D) {
        doubleMatrix1D.toArray(this.tempArray);
        this.add(this.tempArray);
    }

    @Override
    public double covariance(int n, int n2) {
        if (n == n2) {
            return ((Tally)this.get(n)).variance();
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        Tally tally = (Tally)this.get(n);
        Tally tally2 = (Tally)this.get(n2);
        if (tally == null || tally2 == null) {
            return Double.NaN;
        }
        int n4 = tally.numberObs();
        if (n4 != tally2.numberObs()) {
            this.log.logp(Level.WARNING, "ListOfTalliesWithCovariance", "covariance", "Tally " + n + ", with name " + tally.getName() + ", contains " + n4 + " observations while " + "tally " + n2 + ", with name " + tally2.getName() + ", contains " + tally2.numberObs() + "observations");
            return Double.NaN;
        }
        if (n4 < 2) {
            this.log.logp(Level.WARNING, "ListOfTalliesWithCovariance", "covariance", "Tally " + n + ", with name " + tally.getName() + ", contains " + n4 + " observation");
            return Double.NaN;
        }
        if (tally instanceof TallyStore && tally2 instanceof TallyStore) {
            return ((TallyStore)tally).covariance((TallyStore)tally2);
        }
        if (this.isStable) {
            return this.curSum2[n][n2 - n - 1] / (double)(n4 - 1);
        }
        double d = tally.sum();
        double d2 = tally2.sum();
        double d3 = this.sxy[n][n2 - n - 1];
        return (d3 - d * d2 / (double)n4) / (double)(n4 - 1);
    }

    @Override
    public ListOfTalliesWithCovariance<E> clone() {
        int n;
        ListOfTalliesWithCovariance listOfTalliesWithCovariance = (ListOfTalliesWithCovariance)super.clone();
        listOfTalliesWithCovariance.tempArray = new double[this.size()];
        if (this.curAverages != null) {
            listOfTalliesWithCovariance.curAverages = (double[])this.curAverages.clone();
        }
        if (this.sxy != null) {
            listOfTalliesWithCovariance.sxy = new double[this.sxy.length][];
            for (n = 0; n < this.sxy.length; ++n) {
                listOfTalliesWithCovariance.sxy[n] = (double[])this.sxy[n].clone();
            }
        }
        if (this.curSum2 != null) {
            listOfTalliesWithCovariance.curSum2 = new double[this.curSum2.length][];
            for (n = 0; n < this.curSum2.length; ++n) {
                listOfTalliesWithCovariance.curSum2[n] = (double[])this.curSum2[n].clone();
            }
        }
        return listOfTalliesWithCovariance;
    }
}

