/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class NegativeBinomialDist
extends DiscreteDistributionInt {
    protected double gamma;
    protected double p;
    private static final double EPSI = 1.0E-10;
    public static double MAXN = 100000.0;

    protected NegativeBinomialDist() {
    }

    public NegativeBinomialDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double prob(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            if (n > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return NegativeBinomialDist.prob(this.gamma, this.p, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return NegativeBinomialDist.prob(this.gamma, this.p, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.p >= 1.0) {
            return 1.0;
        }
        if (this.p <= 0.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (n >= this.xmax) {
                return 1.0;
            }
            if (n < this.xmin) {
                return NegativeBinomialDist.cdf(this.gamma, this.p, n);
            }
            if (n <= this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n + 1 - this.xmin];
        }
        return NegativeBinomialDist.cdf(this.gamma, this.p, n);
    }

    public double barF(int n) {
        if (n < 1) {
            return 1.0;
        }
        if (this.p >= 1.0) {
            return 0.0;
        }
        if (this.p <= 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return BetaDist.barF(this.gamma, n, 15, this.p);
        }
        if (n > this.xmax) {
            return BetaDist.barF(this.gamma, n, 15, this.p);
        }
        if (n <= this.xmin) {
            return 1.0;
        }
        if (n > this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n - 1 - this.xmin];
    }

    public int inverseFInt(double d) {
        if (this.cdf == null) {
            return NegativeBinomialDist.inverseF(this.gamma, this.p, d);
        }
        return super.inverseFInt(d);
    }

    public double getMean() {
        return NegativeBinomialDist.getMean(this.gamma, this.p);
    }

    public double getVariance() {
        return NegativeBinomialDist.getVariance(this.gamma, this.p);
    }

    public double getStandardDeviation() {
        return NegativeBinomialDist.getStandardDeviation(this.gamma, this.p);
    }

    public static double prob(double d, double d2, int n) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0.0");
        }
        if (n < 0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = Num.lnGamma(d + (double)n) - (Num.lnFactorial(n) + Num.lnGamma(d)) + d * Math.log(d2) + (double)n * Math.log1p(-d2);
        if (d3 >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        if (d3 <= -708.3964185322641) {
            return 0.0;
        }
        return Math.exp(d3);
    }

    public static double cdf(double d, double d2, int n) {
        double d3 = DiscreteDistributionInt.EPSILON;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0.0");
        }
        if (n < 0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            return 1.0;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        int n2 = 1 + (int)Math.floor((d * (1.0 - d2) - 1.0) / d2);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n) {
            n2 = n;
        }
        if (n2 <= 100000) {
            int n3;
            double d4;
            double d5 = d4 = NegativeBinomialDist.prob(d, d2, n2);
            double d6 = d4;
            for (n3 = n2; n3 > 0 && !((d5 *= (double)n3 / ((1.0 - d2) * (d + (double)n3 - 1.0))) < d3); --n3) {
                d6 += d5;
            }
            d5 = d4;
            for (n3 = n2; n3 < n && !((d5 *= (1.0 - d2) * (d + (double)n3) / (double)(n3 + 1)) < d3); ++n3) {
                d6 += d5;
            }
            if (d6 <= 1.0) {
                return d6;
            }
            return 1.0;
        }
        return BetaDist.cdf(d, (double)n + 1.0, 15, d2);
    }

    public static int inverseF(double d, double d2, double d3) {
        double d4;
        if (d3 < 0.0 || d3 >= 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (d2 >= 1.0) {
            return 0;
        }
        if (d2 <= 0.0) {
            return 0;
        }
        if (d3 <= 0.0) {
            return 0;
        }
        if (d3 >= 1.0) {
            return Integer.MAX_VALUE;
        }
        int n = 0;
        int n2 = 1 + (int)Math.floor((d * (1.0 - d2) - 1.0) / d2);
        if (n2 < 0) {
            n2 = 0;
        }
        double d5 = d4 = NegativeBinomialDist.prob(d, d2, n2);
        double d6 = d4;
        for (int i = n2; i > 0 && !((d5 *= (double)i / ((1.0 - d2) * (d + (double)i - 1.0))) < EPSILON); --i) {
            d6 += d5;
        }
        d5 = d4;
        n = n2;
        if (d6 < d3) {
            while (d6 < d3 && !((d5 *= (1.0 - d2) * (d + (double)n) / (double)(n + 1)) < EPSILON)) {
                d6 += d5;
                ++n;
            }
        } else {
            d6 -= d5;
            while (d6 >= d3) {
                --n;
                if (!((d5 *= (double)n / ((1.0 - d2) * (d + (double)n - 1.0))) < EPSILON)) {
                    d6 -= d5;
                    continue;
                }
                break;
            }
        }
        return n;
    }

    public static double[] getMLE(int[] nArray, int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += (double)nArray[i];
        }
        double[] dArray = new double[]{d / (d + (d2 /= (double)n))};
        return dArray;
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n, double d) {
        return NegativeBinomialDist.getMLE(nArray, n, d);
    }

    public static NegativeBinomialDist getInstanceFromMLE(int[] nArray, int n, double d) {
        double[] dArray = NegativeBinomialDist.getMaximumLikelihoodEstimate(nArray, n, d);
        return new NegativeBinomialDist(d, dArray[0]);
    }

    public static double[] getMLE(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n<= 0");
        }
        double d = 0.0;
        double d2 = -2.147483648E9;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
            if (!((double)nArray[i] > d2)) continue;
            d2 = nArray[i];
        }
        double d3 = d / (double)n;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 += ((double)nArray[i] - d3) * ((double)nArray[i] - d3);
        }
        if (d3 >= (d4 /= (double)n)) {
            throw new UnsupportedOperationException("mean >= variance");
        }
        double d5 = d3 * d3 / (d4 - d3);
        int[] nArray2 = new int[(int)d2];
        int n2 = 0;
        while ((double)n2 < d2) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] <= n2) continue;
                ++n3;
            }
            nArray2[n2] = n3;
            ++n2;
        }
        double[] dArray = new double[3];
        Function function = new Function(n, (int)d2, d3, nArray2);
        dArray[1] = RootFinder.brentDekker(d5 / 10.0, d5 * 10.0, function, 1.0E-5);
        dArray[2] = dArray[1] / (dArray[1] + d3);
        double[] dArray2 = new double[]{dArray[1], dArray[2]};
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        return NegativeBinomialDist.getMLE(nArray, n);
    }

    public static NegativeBinomialDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = NegativeBinomialDist.getMaximumLikelihoodEstimate(nArray, n);
        return new NegativeBinomialDist(dArray[0], dArray[1]);
    }

    public static double getMean(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return d * (1.0 - d2) / d2;
    }

    public static double getVariance(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return d * (1.0 - d2) / (d2 * d2);
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(NegativeBinomialDist.getVariance(d, d2));
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getP() {
        return this.p;
    }

    public void setParams(double d, double d2) {
        this.supportA = 0;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.gamma = d;
        this.p = d2;
        int n = 1 + (int)Math.floor((d * (1.0 - d2) - 1.0) / d2);
        if ((double)n < 0.0 || (double)n > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int n2 = (int)(d * (1.0 - d2) / d2 + 16.0 * Math.sqrt(d * (1.0 - d2) / (d2 * d2)));
        if (n2 < 32) {
            n2 = 32;
        }
        double[] dArray = new double[1 + n2];
        double[] dArray2 = new double[1 + n2];
        double d3 = EPSILON / NegativeBinomialDist.prob(d, d2, n);
        dArray[n] = 1.0;
        double d4 = 1.0;
        int n3 = n;
        while (n3 > 0 && dArray[n3] >= d3) {
            dArray[n3 - 1] = dArray[n3] * (double)n3 / ((1.0 - d2) * (d + (double)n3 - 1.0));
            d4 += dArray[--n3];
        }
        int n4 = n3;
        n3 = n;
        while (dArray[n3] >= d3) {
            dArray[n3 + 1] = dArray[n3] * (1.0 - d2) * (d + (double)n3) / (double)(n3 + 1);
            d4 += dArray[++n3];
            if (n3 != n2 - 1) continue;
            double[] dArray3 = new double[1 + (n2 *= 2)];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            dArray = dArray3;
            dArray3 = new double[1 + n2];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            dArray2 = dArray3;
        }
        int n5 = n3;
        n3 = n4;
        while (n3 <= n5) {
            int n6 = n3++;
            dArray[n6] = dArray[n6] / d4;
        }
        dArray2[n4] = dArray[n4];
        n3 = n4;
        while (n3 < n5 && dArray2[n3] < 0.5) {
            dArray2[++n3] = dArray2[n3 - 1] + dArray[n3];
        }
        this.xmed = n3;
        dArray2[n5] = dArray[n5];
        n3 = n5 - 1;
        do {
            dArray2[n3] = dArray[n3] + dArray2[n3 + 1];
        } while (--n3 > this.xmed);
        this.xmin = n4;
        this.xmax = n5;
        this.pdf = new double[n5 + 1 - n4];
        this.cdf = new double[n5 + 1 - n4];
        System.arraycopy(dArray, n4, this.pdf, 0, n5 + 1 - n4);
        System.arraycopy(dArray2, n4, this.cdf, 0, n5 + 1 - n4);
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.gamma, this.p};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : gamma = " + this.gamma + ", p = " + this.p;
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int max;
        protected double mean;
        protected int[] Fj;

        public Function(int n, int n2, double d, int[] nArray) {
            this.m = n;
            this.max = n2;
            this.mean = d;
            this.Fj = new int[nArray.length];
            System.arraycopy(nArray, 0, this.Fj, 0, nArray.length);
        }

        public double evaluate(double d) {
            if (d <= 0.0) {
                return 1.0E100;
            }
            double d2 = 0.0;
            double d3 = d / (d + this.mean);
            for (int i = 0; i < this.max; ++i) {
                d2 += (double)this.Fj[i] / (d + (double)i);
            }
            return d2 + (double)this.m * Math.log(d3);
        }
    }
}

