/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.math.matrixAlgebra.missingData.MissingOps;
import java.util.HashMap;
import java.util.Map;

public class SparseIntegrator
extends ContinuousDiffusionIntegrator.Basic {
    private static final boolean DEBUG = true;
    private static final boolean TIMING = true;
    private double[] sumOfSquares;
    private final Map<String, Long> times;

    public SparseIntegrator(PrecisionType precisionType, int n, int n2, int n3, int n4, int n5) {
        super(precisionType, n, n2, n3, n4, n5);
        assert (precisionType == PrecisionType.FULL);
        this.allocateStorage();
        this.times = new HashMap<String, Long>();
    }

    @Override
    protected void updatePartial(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6 = this.dimPartial * n;
        int n7 = this.dimPartial * n2;
        int n8 = this.dimPartial * n4;
        int n9 = n3;
        int n10 = n5;
        double d = this.branchLengths[n9];
        double d2 = this.branchLengths[n10];
        System.err.println("i:");
        System.err.println("\tvar : " + this.branchLengths[n9]);
        for (int i = 0; i < this.numTraits; ++i) {
            int n11;
            double d3 = this.partials[n7 + this.dimTrait];
            double d4 = this.partials[n8 + this.dimTrait];
            double d5 = Double.isInfinite(d3) ? 1.0 / d : d3 / (1.0 + d3 * d);
            double d6 = Double.isInfinite(d4) ? 1.0 / d2 : d4 / (1.0 + d4 * d2);
            double d7 = Double.isInfinite(d5 + d6) ? Double.POSITIVE_INFINITY : d5 + d6;
            double d8 = Double.isInfinite(d5) ? 1.0 : 1.0 + d6 / d5;
            double d9 = Double.isInfinite(d8) ? 0.0 : 1.0 / d8;
            for (n11 = 0; n11 < this.dimTrait; ++n11) {
                this.partials[n6 + n11] = d9 * this.partials[n7 + n11] + (1.0 - d9) * this.partials[n8 + n11];
            }
            this.partials[n6 + this.dimTrait] = d7;
            System.err.println("\ttrait: " + i);
            System.err.print("\t\tmean i:");
            for (n11 = 0; n11 < this.dimTrait; ++n11) {
                System.err.print(" " + this.partials[n7 + n11]);
            }
            System.err.println(" prec i: " + d3);
            System.err.print("\t\tmean j:");
            for (n11 = 0; n11 < this.dimTrait; ++n11) {
                System.err.print(" " + this.partials[n8 + n11]);
            }
            System.err.println(" prec j: " + d4);
            if (d4 == 0.0) {
                System.exit(-1);
            }
            System.err.print("\t\tmean k:");
            for (n11 = 0; n11 < this.dimTrait; ++n11) {
                System.err.print(" " + this.partials[n6 + n11]);
            }
            System.err.println(" prec k: " + d7);
            System.err.println("");
            double d10 = 0.0;
            if (bl && d3 != 0.0 && d4 != 0.0) {
                d10 += this.computeRemainder(i, n7, n8, n6, d5, d6, d7, bl2);
            }
            this.remainders[n * this.numTraits + i] = d10 + this.remainders[n2 * this.numTraits + i] + this.remainders[n4 * this.numTraits + i];
            n6 += this.dimPartialForTrait;
            n7 += this.dimPartialForTrait;
            n8 += this.dimPartialForTrait;
        }
    }

    private void allocateStorage() {
        this.sumOfSquares = new double[this.numTraits * this.bufferCount];
    }

    private double computeRemainder(int n, int n2, int n3, int n4, double d, double d2, double d3, boolean bl) {
        int n5;
        double d4 = d * d2 / d3;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n6 = this.precisionOffset;
        for (n5 = 0; n5 < this.dimTrait; ++n5) {
            double d9 = this.partials[n2 + n5];
            double d10 = this.partials[n3 + n5];
            double d11 = this.partials[n4 + n5];
            for (int i = 0; i < this.dimTrait; ++i) {
                double d12 = this.partials[n2 + i];
                double d13 = this.partials[n3 + i];
                double d14 = this.partials[n4 + i];
                double d15 = this.diffusions[n6];
                d8 += d9 * d15 * d12;
                d7 += d10 * d15 * d13;
                d6 += d11 * d15 * d14;
                ++n6;
            }
        }
        this.sumOfSquares[n4 + n] = d6;
        System.err.println("\t\t\tpk: " + d3);
        System.err.println("\t\t\tSSi = " + d * d8);
        System.err.println("\t\t\tSSj = " + d2 * d7);
        System.err.println("\t\t\tSSk = " + d3 * d6);
        System.err.println("\t\tremainder: " + (d5 += (double)(-this.dimTrait) * LOG_SQRT_2_PI + 0.5 * ((double)this.dimTrait * Math.log(d4) + this.precisionLogDet) - 0.5 * (d * d8 + d2 * d7 - d3 * d6)));
        if (bl) {
            n5 = this.dimTrait * this.dimTrait * n;
            System.err.println("pip: " + d);
            System.err.println("pjp: " + d2);
            System.err.println("sum: " + (d + d2));
            System.err.println("op prec: " + d4);
            for (int i = 0; i < this.dimTrait; ++i) {
                double d16 = this.partials[n2 + i];
                double d17 = this.partials[n3 + i];
                for (int j = 0; j < this.dimTrait; ++j) {
                    double d18 = this.partials[n2 + j];
                    double d19 = this.partials[n3 + j];
                    int n7 = n5++;
                    this.outerProducts[n7] = this.outerProducts[n7] + (d16 - d17) * (d18 - d19) * d4;
                }
            }
            System.err.println("Outer-products:" + MissingOps.wrap(this.outerProducts, this.dimTrait * this.dimTrait * n, this.dimTrait, this.dimTrait));
            int n8 = n;
            this.degreesOfFreedom[n8] = this.degreesOfFreedom[n8] + 1;
        }
        return d5;
    }
}

