/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.utils.mtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import moa.clusterers.outliers.utils.mtree.DistanceFunction;
import moa.clusterers.outliers.utils.mtree.PartitionFunction;
import moa.clusterers.outliers.utils.mtree.utils.Pair;

public final class PartitionFunctions {
    private PartitionFunctions() {
    }

    public static class BalancedPartition<DATA>
    implements PartitionFunction<DATA> {
        @Override
        public Pair<Set<DATA>> process(final Pair<DATA> promoted, Set<DATA> dataSet, final DistanceFunction<? super DATA> distanceFunction) {
            ArrayList<DATA> queue1 = new ArrayList<DATA>(dataSet);
            Collections.sort(queue1, new Comparator<DATA>(){

                @Override
                public int compare(DATA data1, DATA data2) {
                    double distance1 = distanceFunction.calculate(data1, promoted.first);
                    double distance2 = distanceFunction.calculate(data2, promoted.first);
                    return Double.compare(distance1, distance2);
                }
            });
            ArrayList<DATA> queue2 = new ArrayList<DATA>(dataSet);
            Collections.sort(queue2, new Comparator<DATA>(){

                @Override
                public int compare(DATA data1, DATA data2) {
                    double distance1 = distanceFunction.calculate(data1, promoted.second);
                    double distance2 = distanceFunction.calculate(data2, promoted.second);
                    return Double.compare(distance1, distance2);
                }
            });
            Pair<Set<DATA>> partitions = new Pair<Set<DATA>>(new HashSet(), new HashSet());
            int index1 = 0;
            int index2 = 0;
            block0: while (index1 < queue1.size() || index2 != queue2.size()) {
                Object data;
                while (index1 < queue1.size()) {
                    if (((Set)partitions.second).contains(data = queue1.get(index1++))) continue;
                    ((Set)partitions.first).add(data);
                    break;
                }
                while (index2 < queue2.size()) {
                    if (((Set)partitions.first).contains(data = queue2.get(index2++))) continue;
                    ((Set)partitions.second).add(data);
                    continue block0;
                }
            }
            return partitions;
        }
    }
}

