/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.HashSet;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class DyadicWeightedLiftQF
extends AbstractQFStatisticBased {
    private static final String ID = "DyadicWeightedLiftQF";
    private static final String NAME = "DyadicWeightedLiftQF";

    @Override
    public String getID() {
        return "DyadicWeightedLiftQF";
    }

    @Override
    public String getName() {
        return "DyadicWeightedLiftQF";
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new DyadicWeightedLiftQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double weightedObservedDyads = statistics.getTargetQuantitySG() * statistics.getSubgroupSize();
        HashSet<String> nodes = new HashSet<String>();
        for (DataRecord record : subgroup) {
            String valSrc = ((NominalAttribute)record.getDataset().getAttribute(0)).getNominalValue(record).getId();
            String valDst = ((NominalAttribute)record.getDataset().getAttribute(1)).getNominalValue(record).getId();
            nodes.add(valSrc);
            nodes.add(valDst);
        }
        int count = nodes.size();
        double expectedDyads = (double)count * (double)(count - 1) / 2.0;
        return Math.abs(weightedObservedDyads / expectedDyads);
    }
}

