/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.stats.Snapshot;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CsvReporter
extends AbstractPollingReporter
implements MetricProcessor<Context> {
    private final MetricPredicate predicate;
    private final File outputDir;
    private final Map<MetricName, PrintStream> streamMap;
    private final Clock clock;
    private long startTime;

    public static void enable(File outputDir, long period, TimeUnit unit) {
        CsvReporter.enable(Metrics.defaultRegistry(), outputDir, period, unit);
    }

    public static void enable(MetricsRegistry metricsRegistry, File outputDir, long period, TimeUnit unit) {
        CsvReporter reporter = new CsvReporter(metricsRegistry, outputDir);
        reporter.start(period, unit);
    }

    public CsvReporter(MetricsRegistry metricsRegistry, File outputDir) {
        this(metricsRegistry, MetricPredicate.ALL, outputDir);
    }

    public CsvReporter(MetricsRegistry metricsRegistry, MetricPredicate predicate, File outputDir) {
        this(metricsRegistry, predicate, outputDir, Clock.defaultClock());
    }

    public CsvReporter(MetricsRegistry metricsRegistry, MetricPredicate predicate, File outputDir, Clock clock) {
        super(metricsRegistry, "csv-reporter");
        if (outputDir.exists() && !outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDir + " is not a directory");
        }
        this.outputDir = outputDir;
        this.predicate = predicate;
        this.streamMap = new HashMap<MetricName, PrintStream>();
        this.startTime = 0L;
        this.clock = clock;
    }

    protected PrintStream createStreamForMetric(MetricName metricName) throws IOException {
        File newFile = new File(this.outputDir, metricName.getName() + ".csv");
        if (newFile.createNewFile()) {
            return new PrintStream(new FileOutputStream(newFile));
        }
        throw new IOException("Unable to create " + newFile);
    }

    @Override
    public void run() {
        final long time = TimeUnit.MILLISECONDS.toSeconds(this.clock.time() - this.startTime);
        Set<Map.Entry<MetricName, Metric>> metrics = this.getMetricsRegistry().allMetrics().entrySet();
        try {
            for (Map.Entry<MetricName, Metric> entry2 : metrics) {
                Metric metric;
                final MetricName metricName = entry2.getKey();
                if (!this.predicate.matches(metricName, metric = entry2.getValue())) continue;
                Context context = new Context(){

                    @Override
                    public PrintStream getStream(String header) throws IOException {
                        PrintStream stream = CsvReporter.this.getPrintStream(metricName, header);
                        stream.print(time);
                        stream.print(',');
                        return stream;
                    }
                };
                metric.processWith(this, entry2.getKey(), context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processMeter(MetricName name, Metered meter, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,count,1 min rate,mean rate,5 min rate,15 min rate");
        stream.append("" + meter.count() + ',' + meter.oneMinuteRate() + ',' + meter.meanRate() + ',' + meter.fiveMinuteRate() + ',' + meter.fifteenMinuteRate()).println();
        stream.flush();
    }

    @Override
    public void processCounter(MetricName name, Counter counter, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,count");
        stream.println(counter.count());
        stream.flush();
    }

    @Override
    public void processHistogram(MetricName name, Histogram histogram, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,min,max,mean,median,stddev,95%,99%,99.9%");
        Snapshot snapshot = histogram.getSnapshot();
        stream.append("" + histogram.min() + ',' + histogram.max() + ',' + histogram.mean() + ',' + snapshot.getMedian() + ',' + histogram.stdDev() + ',' + snapshot.get95thPercentile() + ',' + snapshot.get99thPercentile() + ',' + snapshot.get999thPercentile()).println();
        stream.println();
        stream.flush();
    }

    @Override
    public void processTimer(MetricName name, Timer timer, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,min,max,mean,median,stddev,95%,99%,99.9%");
        Snapshot snapshot = timer.getSnapshot();
        stream.append("" + timer.min() + ',' + timer.max() + ',' + timer.mean() + ',' + snapshot.getMedian() + ',' + timer.stdDev() + ',' + snapshot.get95thPercentile() + ',' + snapshot.get99thPercentile() + ',' + snapshot.get999thPercentile()).println();
        stream.flush();
    }

    @Override
    public void processGauge(MetricName name, Gauge<?> gauge, Context context) throws IOException {
        PrintStream stream = context.getStream("# time,value");
        stream.println(gauge.value());
        stream.flush();
    }

    @Override
    public void start(long period, TimeUnit unit) {
        this.startTime = this.clock.time();
        super.start(period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            for (PrintStream out : this.streamMap.values()) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getPrintStream(MetricName metricName, String header) throws IOException {
        PrintStream stream;
        Map<MetricName, PrintStream> map2 = this.streamMap;
        synchronized (map2) {
            stream = this.streamMap.get(metricName);
            if (stream == null) {
                stream = this.createStreamForMetric(metricName);
                this.streamMap.put(metricName, stream);
                stream.println(header);
            }
        }
        return stream;
    }

    public static interface Context {
        public PrintStream getStream(String var1) throws IOException;
    }
}

