/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.connectivity;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.ConnectivityFinder;
import org.chocosolver.util.objects.graphs.IGraph;

public class PropBiconnected
extends Propagator<UndirectedGraphVar> {
    private final UndirectedGraphVar g;
    private final ConnectivityFinder env_CC_finder;

    public PropBiconnected(UndirectedGraphVar graph) {
        super((Variable[])new UndirectedGraphVar[]{graph}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.env_CC_finder = new ConnectivityFinder((IGraph)this.g.getUB());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.g.getPotentialNodes().size() == this.g.getMandatoryNodes().size() && !this.env_CC_finder.isBiconnected()) {
            this.fails();
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_NODE.getMask() + GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_NODE.getMask();
    }

    @Override
    public ESat isEntailed() {
        if (!this.env_CC_finder.isBiconnected()) {
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

