/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.bool;

import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.view.BoolIntView;
import org.chocosolver.util.ESat;

@Explained
public final class BoolGeqView<I extends IntVar>
extends BoolIntView<I> {
    public BoolGeqView(I var, int cste) {
        super("(" + var.getName() + "\u2265" + cste + ")", var, cste);
    }

    @Override
    public ESat getBooleanValue() {
        if (this.var.getUB() < this.cste) {
            return ESat.FALSE;
        }
        return this.var.getLB() >= this.cste ? ESat.TRUE : ESat.UNDEFINED;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        boolean done = false;
        if (value < 0 || value > 1) {
            if (this.getModel().getSolver().isLCG()) {
                this.getModel().getSolver().getSat().cEnqueue(0, reason);
            }
            this.contradiction(cause, "empty domain");
        } else {
            if (this.reactOnRemoval) {
                this.delta.add(1 - value, cause);
            }
            if (done = value == 1 ? this.var.updateLowerBound(this.cste, this, reason) : this.var.updateUpperBound(this.cste - 1, this, reason)) {
                this.fixed.set(done);
                this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            }
        }
        return done;
    }

    @Override
    public int getDomainSize() {
        return this.isInstantiated() ? 1 : 2;
    }

    @Override
    public boolean isInstantiated() {
        if (this.var.getLB() >= this.cste) {
            return true;
        }
        return this.var.getUB() < this.cste;
    }

    @Override
    public boolean contains(int value) {
        if (value == 0) {
            return this.var.getLB() < this.cste;
        }
        if (value == 1) {
            return this.var.getUB() >= this.cste;
        }
        return false;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        if (value == 0) {
            return this.var.getUB() < this.cste;
        }
        if (value == 1) {
            return this.cste <= this.var.getLB();
        }
        return false;
    }

    @Override
    public int getLB() {
        if (this.cste > this.var.getLB()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getUB() {
        if (this.var.getUB() >= this.cste) {
            return 1;
        }
        return 0;
    }

    @Override
    public int nextValue(int v) {
        if (v < 0 && this.contains(0)) {
            return 0;
        }
        return v <= 0 && this.contains(1) ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (this.var.getUB() < this.cste) {
            ub = 0;
        } else if (this.var.getLB() >= this.cste) {
            lb = 1;
        }
        if (lb - 1 <= v && v <= ub) {
            return ub + 1;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > 1 && this.contains(1)) {
            return 1;
        }
        return v >= 1 && this.contains(0) ? 0 : Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (this.var.getUB() < this.cste) {
            ub = 0;
        } else if (this.var.getLB() >= this.cste) {
            lb = 1;
        }
        if (lb <= v && v <= ub + 1) {
            return lb - 1;
        }
        return v - 1;
    }

    @Override
    public int getLit(int val, int type) {
        if (val < 0) {
            return 1 ^ type & 1;
        }
        if (val > 1) {
            return type - 1 >> 1 & 1;
        }
        switch (type) {
            case 0: {
                return this.var.getLit(this.cste, 2) - val;
            }
            case 1: {
                return this.var.getLit(this.cste, 2) + val - 1;
            }
            case 2: {
                return val == 1 ? this.var.getLit(this.cste, 2) + val - 1 : 1;
            }
            case 3: {
                return val == 0 ? this.var.getLit(this.cste, 2) + val - 1 : 1;
            }
        }
        throw new UnsupportedOperationException("BoolGeqView#getLit");
    }

    @Override
    public int getMinLit() {
        return MiniSat.neg(this.getLit(this.getLB(), 2));
    }

    @Override
    public int getMaxLit() {
        return MiniSat.neg(this.getLit(this.getUB(), 3));
    }

    @Override
    public int getValLit() {
        assert (this.isInstantiated()) : this + " is not instantiated";
        return this.getLit(this.getLB(), 0);
    }

    @Override
    public int satVar() {
        if (this.getModel().getSolver().isLCG()) {
            return MiniSat.var(this.getLit(1, 1));
        }
        return super.satVar();
    }
}

