## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----load-and-setup, echo=FALSE, message=FALSE, warning=FALSE-----------------
library(andorR)
data(ethical)

## ----setup-tree-boosting------------------------------------------------------
library(andorR)
data(ethical)
dtree <- load_tree_df(ethical)

# Provide some initial answers with varying confidence
set_answer(dtree, "FIN1", TRUE, 5) # Parent "Profitability" becomes TRUE
set_answer(dtree, "FIN4", TRUE, 2) # Low confidence
set_answer(dtree, "FIN5", TRUE, 2) # Low confidence
set_answer(dtree, "ENV1", TRUE, 4)
set_answer(dtree, "ENV2", TRUE, 3)
set_answer(dtree, "ENV3", TRUE, 4) # Parent "Clean Record" becomes TRUE
set_answer(dtree, "SOC2", TRUE, 4)
set_answer(dtree, "GOV1", TRUE, 5)
set_answer(dtree, "GOV2", TRUE, 5)
set_answer(dtree, "GOV3", TRUE, 5)
set_answer(dtree, "GOV4", TRUE, 5)
set_answer(dtree, "GOV5", TRUE, 5) # Parent "Strong Corporate Governance" becomes TRUE
# Tree root becomes TRUE

# Recalculate the tree state
dtree <- update_tree(dtree)

## ----print-initial-conclusion-------------------------------------------------
print_tree(dtree)

## ----get-guidance-------------------------------------------------------------
guidance <- get_confidence_boosters(dtree)
knitr::kable(guidance, caption = "Top Actions to Boost Confidence")

## ----act-on-guidance----------------------------------------------------------
# Edit the existing answer for FIN5 with a new, higher confidence
set_answer(dtree, "FIN5", TRUE, 5)

# Recalculate the entire tree
dtree <- update_tree(dtree)

## ----final-print--------------------------------------------------------------
print_tree(dtree)

