/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.PSO_ACO;

import java.io.IOException;
import java.util.Arrays;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    private double[][] X = null;
    private boolean[][] missing = null;
    private int[] C = null;
    private double[] emaximo;
    private double[] eminimo;
    private double smaximo;
    private double sminimo;
    private int ndatos;
    private int nvariables;
    private int nentradas;
    private int nclases;
    static final boolean debug = false;
    public InstanceSet IS = new InstanceSet();
    private int[] comunes;

    public double[][] getX() {
        return this.X;
    }

    public int[] getC() {
        int[] retorno = new int[this.C.length];
        for (int i = 0; i < this.C.length; ++i) {
            retorno[i] = this.C[i];
        }
        return retorno;
    }

    public double[] getemaximo() {
        return this.emaximo;
    }

    public double[] geteminimo() {
        return this.eminimo;
    }

    public int getndatos() {
        return this.ndatos;
    }

    public int getnvariables() {
        return this.nvariables;
    }

    public int getnentradas() {
        return this.nentradas;
    }

    public int getnclases() {
        return this.nclases;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readClassificationSet(String datasetFile, boolean train) throws IOException {
        try {
            this.IS.readSet(datasetFile, train);
            this.ndatos = this.IS.getNumInstances();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nvariables = this.nentradas + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.ndatos][this.nentradas];
            this.missing = new boolean[this.ndatos][this.nentradas];
            this.C = new int[this.ndatos];
            this.emaximo = new double[this.nentradas];
            this.eminimo = new double[this.nentradas];
            this.nclases = 0;
            for (int i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nentradas; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.emaximo[j] || i == 0) {
                        this.emaximo[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.eminimo[j]) && i != 0) continue;
                    this.eminimo[j] = this.X[i][j];
                }
                this.C[i] = noOutputs ? 0 : (int)this.IS.getOutputNumericValue(i, 0);
                if (this.C[i] <= this.nclases) continue;
                this.nclases = this.C[i];
            }
            ++this.nclases;
            System.out.println("Number of classes=" + this.nclases);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public int[] tiposVar() {
        int[] tipos = new int[this.nentradas];
        for (int i = 0; i < this.nentradas; ++i) {
            tipos[i] = 1;
            if (Attributes.getAttribute(i).getType() != 0) continue;
            tipos[i] = 0;
        }
        return tipos;
    }

    public void calculaMasComunes() {
        this.comunes = new int[this.nentradas];
        int[] aux = new int[this.ndatos];
        for (int i = 0; i < this.nentradas; ++i) {
            for (int j = 0; j < this.ndatos; ++j) {
                aux[j] = this.isMissing(j, i) ? -1 : (int)this.X[j][i];
            }
            Arrays.sort(aux);
            int mascomun = aux[0];
            int contador = 1;
            int j = 1;
            while (aux[j] == mascomun && j < this.ndatos - 1) {
                ++j;
                ++contador;
            }
            int contador2 = 1;
            int mascomun2 = aux[j];
            if (j + 1 < this.ndatos) {
                ++j;
                while (j < this.ndatos) {
                    if (aux[j] == mascomun2) {
                        ++contador2;
                    } else {
                        mascomun2 = aux[j];
                        if (contador2 > contador) {
                            contador = contador2;
                            mascomun = mascomun2;
                            contador2 = 1;
                        }
                    }
                    ++j;
                }
            }
            this.comunes[i] = mascomun;
        }
    }

    public int masComun(int i) {
        return this.comunes[i];
    }

    private double dameRangoSup(int i) {
        return Attributes.getAttribute(i).getMaxAttribute();
    }

    private double dameRangoInf(int i) {
        return Attributes.getAttribute(i).getMinAttribute();
    }

    public double[][] dameRangos() {
        double[][] rangos = new double[this.getnentradas()][2];
        for (int i = 0; i < this.getnentradas(); ++i) {
            rangos[i][0] = this.dameRangoInf(i);
            rangos[i][1] = this.dameRangoSup(i);
        }
        return rangos;
    }

    public int[] dameTipos() {
        int[] tipos = new int[this.getnentradas()];
        for (int i = 0; i < this.getnentradas(); ++i) {
            tipos[i] = Attributes.getAttribute(i).getType() + 2;
        }
        return tipos;
    }

    public String[] dameNombres() {
        String[] salida = new String[this.nvariables];
        for (int i = 0; i < this.nentradas; ++i) {
            salida[i] = Attributes.getInputAttribute(i).getName();
        }
        salida[this.nentradas] = Attributes.getOutputAttribute(0).getName();
        return salida;
    }

    public String[] dameClases() {
        String[] salida = new String[this.nclases];
        Attribute at = Attributes.getOutputAttribute(0);
        if (at.getType() == 0) {
            for (int i = 0; i < this.nclases; ++i) {
                salida[i] = at.getNominalValue(i);
            }
        } else {
            salida = null;
        }
        return salida;
    }

    public String[][] dameValores() {
        String[][] salida = new String[this.nentradas][];
        for (int i = 0; i < this.nentradas; ++i) {
            int j;
            Attribute at = Attributes.getInputAttribute(i);
            if (at.getType() == 0) {
                salida[i] = new String[at.getNumNominalValues()];
                for (j = 0; j < at.getNumNominalValues(); ++j) {
                    salida[i][j] = at.getNominalValue(j);
                }
                continue;
            }
            if (at.getType() != 1) continue;
            salida[i] = new String[(int)at.getMaxAttribute() - (int)at.getMinAttribute() + 1];
            j = 0;
            int k = (int)at.getMinAttribute();
            while (j < (int)at.getMaxAttribute() - (int)at.getMinAttribute() + 1) {
                salida[i][j] = "" + k;
                ++j;
                ++k;
            }
        }
        return salida;
    }

    public double[] valoresMin() {
        double[] min = new double[this.nentradas];
        for (int i = 0; i < this.nentradas; ++i) {
            Attribute at = Attributes.getInputAttribute(i);
            min[i] = at.getType() == 1 ? at.getMinAttribute() : 0.0;
        }
        return min;
    }

    public boolean hayAtributosContinuos() {
        return Attributes.hasRealAttributes();
    }
}

