/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCPAR;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.Rule;
import keel.Algorithms.Associative_Classification.ClassifierCPAR.myDataset;
import org.core.Fichero;

public class RuleBase {
    ArrayList<Rule> ruleBase;
    DataBase dataBase;
    myDataset train;
    int n_variables;
    int nClasses;
    int K;

    public RuleBase() {
    }

    public RuleBase(DataBase dataBase, myDataset train, int K) {
        this.dataBase = dataBase;
        this.train = train;
        this.K = K;
        this.n_variables = dataBase.numVariables();
        this.nClasses = train.getnClasses();
        this.ruleBase = new ArrayList();
    }

    public void add(Rule rule) {
        this.ruleBase.add(rule);
    }

    public Rule get(int pos) {
        return this.ruleBase.get(pos);
    }

    public int size() {
        return this.ruleBase.size();
    }

    public void sort() {
        Collections.sort(this.ruleBase);
    }

    public Rule remove(int pos) {
        return this.ruleBase.remove(pos);
    }

    public double evaluate() {
        int nHits = 0;
        for (int j = 0; j < this.train.size(); ++j) {
            int Prediction = this.FRM_WR(this.train.getExample(j));
            if (this.train.getOutputAsInteger(j) != Prediction) continue;
            ++nHits;
        }
        return 100.0 * (double)nHits / (1.0 * (double)this.train.size());
    }

    public int FRM(int[] example) {
        return this.FRM_WR(example);
    }

    private int FRM_WR(int[] example) {
        int clas = -1;
        double bestSum = -1.0;
        for (int i = 0; i < this.nClasses; ++i) {
            int count = 0;
            double sum = 0.0;
            for (int j = 0; j < this.ruleBase.size() && count < this.K; ++j) {
                Rule r = this.ruleBase.get(j);
                if (r.getClas() != i || !(r.matching(example) > 0.0)) continue;
                ++count;
                sum += r.getLaplace();
            }
            if (count <= 0) continue;
            sum /= (double)count;
            if (clas >= 0 && !(bestSum < sum)) continue;
            clas = i;
            bestSum = sum;
        }
        return clas;
    }

    public String printString() {
        String[] names = this.train.names();
        String[] clases = this.train.clases();
        String stringOut = new String("");
        int ant = 0;
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            int j;
            Rule r = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            for (j = 0; j < this.n_variables && r.antecedent[j] < 0; ++j) {
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                ++ant;
            }
            ++j;
            while (j < this.n_variables - 1) {
                if (r.antecedent[j] >= 0) {
                    stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                    ++ant;
                }
                ++j;
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]) + ": " + clases[r.clas] + "\n";
                ++ant;
                continue;
            }
            stringOut = stringOut + ": " + clases[r.clas] + "\n";
        }
        stringOut = stringOut + "\n\n";
        stringOut = "@Number of rules: " + (this.size() + 1) + " Number of Antecedents by rule: " + (double)ant * 1.0 / (double)this.size() + "\n\n" + stringOut;
        return stringOut;
    }

    public void saveFile(String filename) {
        String stringOut = new String("");
        stringOut = this.printString();
        Fichero.escribeFichero(filename, stringOut);
    }
}

