/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.LVQ;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ2;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class LVQ2_1
extends LVQ2 {
    public LVQ2_1(PrototypeSet T, int iterations, int n_prot, double alpha_0, double windowWidth) {
        super(T, iterations, n_prot, alpha_0, windowWidth);
        this.algorithmName = "LVQ2.1";
    }

    public LVQ2_1(PrototypeSet T, int iterations, double pcNprot, double alpha_0, double windowWidth) {
        super(T, iterations, pcNprot, alpha_0, windowWidth);
        this.algorithmName = "LVQ2.1";
    }

    public LVQ2_1(PrototypeSet T, Parameters parameters) {
        super(T, parameters);
        this.algorithmName = "LVQ2.1";
    }

    protected void hardCorrect(Prototype i, PrototypeSet tData) {
        Prototype nDifferentClass;
        Prototype nSameClass = KNN.getNearestWithSameClassAs(i, tData);
        if (this.isInsideTheWindow(i, nSameClass, nDifferentClass = KNN.getNearestWithDifferentClassAs(i, tData))) {
            this.reward(nSameClass, i);
            this.penalize(nDifferentClass, i);
        }
    }

    @Override
    protected void correct(Prototype i, PrototypeSet tData) {
        PrototypeSet nearest = KNN.getNearestNeighbors(i, tData, 2);
        Prototype n1 = (Prototype)nearest.get(0);
        Prototype n2 = (Prototype)nearest.get(1);
        Prototype m_c = null;
        Prototype m_d = null;
        boolean passed = false;
        if (n1.label() == i.label() && n2.label() != i.label()) {
            passed = true;
            m_c = n1;
            m_d = n2;
        } else if (n2.label() == i.label() && n1.label() != i.label()) {
            passed = true;
            m_d = n1;
            m_c = n2;
        }
        if (passed && this.isInsideTheWindow(i, m_c, m_d)) {
            this.reward(m_c, i);
            this.penalize(m_d, i);
        }
    }

    public static void main(String[] args) {
        Parameters.setUse("LVQ2_1", "<seed> <number of iterations> <% of prototypes> <alpha_0> <window width>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        int iter = Parameters.assertExtendedArgAsInt(args, 3, "number of iterations", 1.0, 2.147483647E9);
        double pcNprot = Parameters.assertExtendedArgAsDouble(args, 4, "reduction size respect training size", 0.0, 100.0);
        double alpha_0 = Parameters.assertExtendedArgAsDouble(args, 5, "alpha_0", 0.0, 1.0);
        double window_width = Parameters.assertExtendedArgAsDouble(args, 6, "window width", 0.0, 1.0);
        LVQ2_1.setSeed(seed);
        LVQ2_1 generator = new LVQ2_1(training, iter, pcNprot, alpha_0, window_width);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

