/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal;

import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyAttribute;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyRegion;

public class Gene {
    private double[] displacements;

    public Gene(double[] displacements) {
        this.setDisplacements(displacements);
    }

    private void setDisplacements(double[] displacements) {
        this.displacements = new double[displacements.length];
        for (int i = 0; i < this.displacements.length; ++i) {
            this.displacements[i] = displacements[i];
        }
    }

    public double[] getDisplacements() {
        return this.displacements;
    }

    public double calculateOverlapFactor(FuzzyAttribute uniform_fuzzy_attr) {
        FuzzyRegion[] initial_fuzzy_regions = uniform_fuzzy_attr.getFuzzyRegions();
        double overlap_factor = 0.0;
        for (int r = 0; r < this.displacements.length - 1; ++r) {
            double x0_mf2;
            double x3_mf1 = initial_fuzzy_regions[r].getX3() + this.displacements[r];
            if (!(x3_mf1 > (x0_mf2 = initial_fuzzy_regions[r + 1].getX0() + this.displacements[r + 1]))) continue;
            double x0_mf1 = initial_fuzzy_regions[r].getX0() + this.displacements[r];
            double x1_mf1 = initial_fuzzy_regions[r].getX1() + this.displacements[r];
            overlap_factor += Math.max((x3_mf1 - x0_mf2) / (x1_mf1 - x0_mf1), 1.0) - 1.0;
        }
        return overlap_factor;
    }

    public Gene clone() {
        Gene gene = new Gene(this.displacements);
        return gene;
    }

    public boolean equals(Object obj) {
        Gene g = (Gene)obj;
        boolean ok = true;
        for (int i = 0; i < this.displacements.length && ok; ++i) {
            if (g.displacements[i] == this.displacements[i]) continue;
            ok = false;
        }
        return ok;
    }

    public String toString() {
        int i;
        String str = "[";
        for (i = 0; i < this.displacements.length - 1; ++i) {
            str = str + this.displacements[i] + "; ";
        }
        str = str + this.displacements[i] + "]";
        return str;
    }
}

