/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.AlatasetalProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.parseParameters;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class Alatasetal {
    private myDataset trans;
    private String rulesFilename;
    private String valuesFilename;
    String valuesOrderFilename;
    private AlatasetalProcess proc;
    private ArrayList<AssociationRule> associationRules;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    private int nTrials;
    private int randomChromosomes;
    private int r;
    private int tournamentSize;
    private double pc;
    private double pmMin;
    private double pmMax;
    private double a1;
    private double a2;
    private double a3;
    private double a4;
    private double a5;
    private double af;
    private double minSupport;
    long startTime;
    long totalTime;
    private boolean somethingWrong = false;

    public Alatasetal() {
    }

    public Alatasetal(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.trans = new myDataset();
        try {
            this.namedataset = parameters.getTransactionsInputFile();
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.trans.hasMissingAttributes();
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.valuesFilename = parameters.getOutputFile(0);
        this.valuesOrderFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(0).substring(0, parameters.getOutputFile(0).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.nTrials = Integer.parseInt(parameters.getParameter(1));
        this.randomChromosomes = Integer.parseInt(parameters.getParameter(2));
        int r = Integer.parseInt(parameters.getParameter(3));
        this.tournamentSize = Integer.parseInt(parameters.getParameter(4));
        this.pc = Double.parseDouble(parameters.getParameter(5));
        this.pmMin = Double.parseDouble(parameters.getParameter(6));
        this.pmMax = Double.parseDouble(parameters.getParameter(7));
        this.a1 = Double.parseDouble(parameters.getParameter(8));
        this.a2 = Double.parseDouble(parameters.getParameter(9));
        this.a3 = Double.parseDouble(parameters.getParameter(10));
        this.a4 = Double.parseDouble(parameters.getParameter(11));
        this.a5 = Double.parseDouble(parameters.getParameter(12));
        this.af = Double.parseDouble(parameters.getParameter(13));
        this.minSupport = 0.001;
        this.r = this.trans.getnVars() >= r ? r : this.trans.getnVars();
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new AlatasetalProcess(this.trans, this.nTrials, this.randomChromosomes, this.r, this.tournamentSize, this.pc, this.pmMin, this.pmMax, this.a1, this.a2, this.a3, this.a4, this.a5, this.af);
            this.proc.run();
            this.associationRules = this.proc.generateRulesSet(this.minSupport);
            try {
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                PrintWriter valueOrder_writer = new PrintWriter(this.valuesOrderFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<association_rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.println("<values>");
                valueOrder_writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                valueOrder_writer.println("<values>");
                for (int r = 0; r < this.associationRules.size(); ++r) {
                    int i;
                    AssociationRule a_r = this.associationRules.get(r);
                    rules_writer.println("<rule id=\"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + AlatasetalProcess.roundDouble(a_r.getSupport(), 2) + "\" antecedent_support=\"" + AlatasetalProcess.roundDouble(a_r.getAntecedentSupport(), 2) + "\" consequent_support=\"" + AlatasetalProcess.roundDouble(a_r.getConsequentSupport(), 2) + "\" confidence=\"" + AlatasetalProcess.roundDouble(a_r.getConfidence(), 2) + "\" lift=\"" + AlatasetalProcess.roundDouble(a_r.getLift(), 2) + "\" conviction=\"" + AlatasetalProcess.roundDouble(a_r.getConv(), 2) + "\" certainFactor=\"" + AlatasetalProcess.roundDouble(a_r.getCF(), 2) + "\" netConf=\"" + AlatasetalProcess.roundDouble(a_r.getnetConf(), 2) + "\" yulesQ=\"" + AlatasetalProcess.roundDouble(a_r.getyulesQ(), 2) + "\" nAttributes=\"" + (a_r.getAntecedents().length + a_r.getConsequents().length) + "\"/>");
                    rules_writer.println("<antecedents>");
                    Gene[] terms = a_r.getAntecedents();
                    ArrayList<Integer> id_attrs = a_r.getIdOfAntecedents();
                    for (i = 0; i < terms.length; ++i) {
                        this.createRule(terms[i], id_attrs.get(i), rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    terms = a_r.getConsequents();
                    id_attrs = a_r.getIdOfConsequents();
                    for (i = 0; i < terms.length; ++i) {
                        this.createRule(terms[i], id_attrs.get(i), rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                }
                rules_writer.println("</association_rules>");
                values_writer.println("</values>");
                rules_writer.close();
                values_writer.close();
                valueOrder_writer.print(this.proc.printRules(this.associationRules));
                valueOrder_writer.println("</values>");
                valueOrder_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("Algorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.rulesFilename + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.rulesFilename + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(Gene g, int id_attr, PrintWriter w) {
        w.println("<attribute name=\"" + Attributes.getAttribute(id_attr).getName() + "\" value=\"");
        if (!g.getIsPositiveInterval()) {
            w.print("NOT ");
        }
        if (this.trans.getAttributeType(id_attr) == 0) {
            w.print(Attributes.getAttribute(id_attr).getNominalValue((int)g.getLowerBound()));
        } else {
            w.print("[" + g.getLowerBound() + ", " + g.getUpperBound() + "]");
        }
        w.print("\" />");
    }
}

