/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.Serializable;
import java.util.Map;
import javolution.lang.Reference;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentReference<T>
implements Reference<T>,
Serializable {
    private static final FastMap COLLECTION = new FastMap();
    private static final FastMap VALUES = new FastMap();
    private static final Object LOCK = new Object();
    private final String _id;
    private volatile T _value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentReference(String string, T t) {
        Object object = LOCK;
        synchronized (object) {
            if (COLLECTION.containsKey(string)) {
                throw new IllegalArgumentException("id: " + string + " in use");
            }
            this._id = string;
            this._value = VALUES.containsKey(string) ? VALUES.get(string) : t;
            COLLECTION.put(string, this);
            VALUES.put(string, this._value);
        }
    }

    public String id() {
        return this._id;
    }

    @Override
    public T get() {
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T t) {
        Object object = LOCK;
        synchronized (object) {
            this._value = t;
            VALUES.put(this._id, this._value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimum(T t) {
        Object object = LOCK;
        synchronized (object) {
            if (t instanceof Comparable) {
                if (((Comparable)t).compareTo(this._value) > 0) {
                    this._value = t;
                    VALUES.put(this._id, this._value);
                }
            } else if (t instanceof Integer) {
                if ((Integer)t > (Integer)this._value) {
                    this._value = t;
                    VALUES.put(this._id, this._value);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximum(T t) {
        Object object = LOCK;
        synchronized (object) {
            if (t instanceof Comparable) {
                if (((Comparable)t).compareTo(this._value) < 0) {
                    this._value = t;
                    VALUES.put(this._id, this._value);
                }
            } else if (t instanceof Integer) {
                if ((Integer)t < (Integer)this._value) {
                    this._value = t;
                    VALUES.put(this._id, this._value);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public static Map values() {
        return VALUES.unmodifiable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(String string, Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            if (COLLECTION.containsKey(string)) {
                PersistentReference persistentReference = (PersistentReference)COLLECTION.get(string);
                persistentReference._value = object;
            }
            VALUES.put(string, object);
        }
    }

    public static void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            PersistentReference.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

