/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.exceptions.CannotConstructException;
import com.hp.hpl.jena.assembler.exceptions.NotUniqueException;
import com.hp.hpl.jena.assembler.exceptions.PropertyRequiredException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;

public abstract class AssemblerBase
implements Assembler {
    static final Map1 getObject = new Map1(){

        public Object map1(Object o) {
            return ((Statement)o).getObject();
        }
    };

    public final Object open(Resource root) {
        return this.open(this, root);
    }

    public final Object open(Assembler a, Resource root) {
        return this.open(a, root, Mode.DEFAULT);
    }

    public abstract Object open(Assembler var1, Resource var2, Mode var3);

    protected static Resource getUniqueResource(Resource root, Property property) {
        return (Resource)AssemblerBase.getUnique(root, property);
    }

    protected static Literal getUniqueLiteral(Resource root, Property property) {
        return (Literal)AssemblerBase.getUnique(root, property);
    }

    protected static Statement getUniqueStatement(Resource root, Property property) {
        List statements = IteratorCollection.iteratorToList(root.listProperties(property));
        if (statements.size() == 0) {
            return null;
        }
        if (statements.size() == 1) {
            return (Statement)statements.get(0);
        }
        throw new NotUniqueException(root, property);
    }

    protected static RDFNode getUnique(Resource root, Property property) {
        List nodes = IteratorCollection.iteratorToList(root.listProperties(property).mapWith(getObject));
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return (RDFNode)nodes.get(0);
        }
        throw new NotUniqueException(root, property);
    }

    protected void checkType(Resource root, Resource type) {
        if (!root.hasProperty(RDF.type, type)) {
            throw new CannotConstructException(this.getClass(), root, type);
        }
    }

    public Model openModel(Resource root, Mode mode) {
        return (Model)this.open(this, root, mode);
    }

    public Model openModel(Resource root) {
        return this.openModel(root, Mode.DEFAULT);
    }

    public static Resource getRequiredResource(Resource root, Property p) {
        Resource R = AssemblerBase.getUniqueResource(root, p);
        if (R == null) {
            throw new PropertyRequiredException(root, p);
        }
        return R;
    }

    protected Literal getRequiredLiteral(Resource root, Property p) {
        Literal L = AssemblerBase.getUniqueLiteral(root, p);
        if (L == null) {
            throw new PropertyRequiredException(root, p);
        }
        return L;
    }

    protected static Resource getResource(Statement s) {
        return AssemblerHelp.getResource(s);
    }

    protected static String getString(Statement s) {
        return AssemblerHelp.getString(s);
    }

    protected static String getUniqueString(Resource root, Property property) {
        Statement s = AssemblerBase.getUniqueStatement(root, property);
        return s == null ? null : AssemblerHelp.getString(s);
    }

    protected static class MapObjectToContent
    implements Map1 {
        protected final Assembler a;

        public MapObjectToContent(Assembler a) {
            this.a = a;
        }

        public Object map1(Object o) {
            return this.a.open(AssemblerBase.getResource((Statement)o));
        }
    }
}

