/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.MeanTest;
import ec.tstoolkit.stats.StatisticalTest;

public class StabilityTest {
    private DescriptiveStatistics stats_;
    private DescriptiveStatistics stats0_;
    private DescriptiveStatistics stats1_;
    private MeanTest m_;
    private MeanTest m0_;
    private MeanTest m1_;
    private StatisticalTest f_;
    private StatisticalTest msame_;
    private double prob_ = 0.01;

    public boolean process(IReadDataBlock data) {
        this.stats_ = new DescriptiveStatistics(data);
        int n = data.getLength();
        int n2 = (1 + n) / 2;
        this.stats0_ = new DescriptiveStatistics(data.rextract(0, n2));
        this.stats1_ = new DescriptiveStatistics(data.rextract(n2, n - n2));
        this.m_ = new MeanTest();
        this.m_.sampleMean(this.stats_, 0.0, TestType.TwoSided);
        this.m_.setSignificanceThreshold(this.prob_);
        this.m0_ = new MeanTest();
        this.m0_.sampleMean(this.stats0_, 0.0, TestType.TwoSided);
        this.m0_.setSignificanceThreshold(this.prob_);
        this.m1_ = new MeanTest();
        this.m1_.sampleMean(this.stats1_, 0.0, TestType.TwoSided);
        this.m1_.setSignificanceThreshold(this.prob_);
        this.f_ = MeanTest.compareVariances(this.m0_, this.m1_);
        this.f_.setSignificanceThreshold(this.prob_);
        return true;
    }

    public double getSignificance() {
        return this.prob_;
    }

    public void setSignificance(double p) {
        this.prob_ = p;
        if (this.f_ != null) {
            this.f_.setSignificanceThreshold(this.prob_);
        }
        if (this.m_ != null) {
            this.m_.setSignificanceThreshold(this.prob_);
        }
        if (this.m0_ != null) {
            this.m0_.setSignificanceThreshold(this.prob_);
        }
        if (this.m1_ != null) {
            this.m1_.setSignificanceThreshold(this.prob_);
        }
    }

    public StatisticalTest getVariancesTest() {
        return this.f_;
    }

    public StatisticalTest getMeansTest() {
        if (this.msame_ == null) {
            this.msame_ = MeanTest.compareMeans(this.m_, this.m_, !this.f_.isSignificant());
        }
        return this.msame_;
    }

    public boolean isSameVariance() {
        return !this.f_.isSignificant();
    }

    public boolean isSameMean() {
        if (this.is0StartMean() && this.is0EndMean()) {
            return true;
        }
        if (!this.is0StartMean() && !this.is0EndMean()) {
            return !this.getMeansTest().isSignificant();
        }
        return false;
    }

    public MeanTest getFullMeanTest() {
        return this.m_;
    }

    public MeanTest getStartMeanTest() {
        return this.m0_;
    }

    public MeanTest getEndMeanTest() {
        return this.m1_;
    }

    public boolean is0FullMean() {
        return this.m_ != null ? !this.m_.isSignificant() : false;
    }

    public boolean is0StartMean() {
        return this.m0_ != null ? !this.m0_.isSignificant() : false;
    }

    public boolean is0EndMean() {
        return this.m1_ != null ? !this.m1_.isSignificant() : false;
    }
}

