/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import java.util.Arrays;

public class AutoCorrelations {
    private double[] m_auto;
    private double[] m_pauto;
    private double[] m_pc;
    private boolean m_bmean;
    private int m_kmax;
    private static int g_atom = 4;
    DescriptiveStatistics stats;

    public AutoCorrelations(DescriptiveStatistics stats) {
        this.stats = stats;
    }

    public AutoCorrelations(IReadDataBlock data) {
        this.stats = new DescriptiveStatistics(data);
    }

    public double autoCorrelation(int order) {
        if (order == 0) {
            return 1.0;
        }
        this.checkAC(order);
        return this.m_auto[order - 1];
    }

    protected void calcAutoCorrelations() {
        this.m_auto = new double[this.m_kmax];
        if (this.m_bmean) {
            double[] tmp = (double[])this.stats.internalStorage().clone();
            int n = tmp.length;
            double m = this.stats.getAverage();
            for (int i = 0; i < n; ++i) {
                if (!Double.isFinite(tmp[i])) continue;
                int n2 = i;
                tmp[n2] = tmp[n2] - m;
            }
            this.m_auto = DescriptiveStatistics.ac(this.m_kmax, tmp);
        } else {
            this.m_auto = DescriptiveStatistics.ac(this.m_kmax, this.stats.internalStorage());
        }
    }

    protected void calcPartialAutoCorrelations() {
        this.m_pc = new double[this.m_auto.length];
        this.m_pauto = DescriptiveStatistics.pac(this.m_auto, this.m_pc);
    }

    private void checkAC(int order) {
        if (order == 0) {
            return;
        }
        if (this.m_auto == null || this.m_auto.length < order) {
            if (this.m_kmax < order) {
                this.m_kmax = this.nextK(order);
            }
            this.calcAutoCorrelations();
        }
    }

    private void checkPAC(int order) {
        if (order == 0) {
            return;
        }
        if (this.m_pauto == null || this.m_pauto.length < order) {
            this.checkAC(order);
            this.calcPartialAutoCorrelations();
        }
    }

    public double[] getAC() {
        this.checkAC(this.m_kmax);
        return Arrays.copyOf(this.m_auto, this.m_kmax);
    }

    public double getDurbinWatson() {
        double nom = 0.0;
        double[] data = this.stats.internalStorage();
        int n = data.length;
        for (int i = 1; i < n; ++i) {
            double cur = data[i];
            double prev = data[i - 1];
            if (!Double.isFinite(cur)) continue;
            nom += (cur - prev) * (cur - prev);
        }
        return nom / this.stats.getSumSquare();
    }

    public int getKMax() {
        return this.m_kmax;
    }

    public double[] getPAC() {
        this.checkPAC(this.m_kmax);
        return Arrays.copyOf(this.m_pauto, this.m_kmax);
    }

    public double[] getPACCoefficients() {
        this.checkPAC(this.m_kmax);
        return this.m_pc;
    }

    public DescriptiveStatistics getUnderlyingData() {
        return this.stats;
    }

    public boolean isCorrectedForMean() {
        return this.m_bmean;
    }

    public int nextK(int k) {
        if (k <= 1) {
            k = g_atom;
        }
        int n = (k - 1) / g_atom;
        int nmax = this.stats.getDataCount() * 3 / 4;
        if ((n = (n + 1) * g_atom) > nmax) {
            n = nmax;
        }
        return n;
    }

    public double partialAutoCorrelation(int order) {
        if (order == 0) {
            return 1.0;
        }
        this.checkPAC(order);
        return this.m_pauto[order - 1];
    }

    protected void recalc() {
        this.calcAutoCorrelations();
        this.calcPartialAutoCorrelations();
    }

    public void setCorrectedForMean(boolean bool) {
        this.m_bmean = bool;
        this.m_auto = null;
        this.m_pauto = null;
        this.m_pc = null;
    }

    public void setKMax(int value) {
        this.m_kmax = this.nextK(value);
    }
}

