/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.jdbc.common.SStatement;
import com.amazon.jdbc.common.utilities.WrapperUtilities;
import com.amazon.streams.resultsetinput.AbstractDataStream;
import com.amazon.streams.resultsetinput.AsciiDataStream;
import com.amazon.streams.resultsetinput.BinaryDataStream;
import com.amazon.streams.resultsetinput.CharacterDataStream;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.TypeNames;
import com.amazon.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class SUpdatableForwardResultSet
extends SForwardResultSet {
    private boolean m_isOnInsertRow = false;
    protected boolean m_hasUpdateValues = false;
    protected List<DataWrapper> m_updateValues = new ArrayList<DataWrapper>();
    protected List<AbstractDataStream> m_updateStreamValues = new ArrayList<AbstractDataStream>();
    private long m_updatableSupport;

    protected SUpdatableForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sStatement, iResultSet, iLogger);
            Variant variant = sStatement.getStatement().getParentConnection().getProperty(1001);
            this.m_updatableSupport = variant.getLong();
            for (int i = this.getMetaData().getColumnCount(); i > 0; --i) {
                this.m_updateValues.add(null);
                this.m_updateStreamValues.add(null);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
        return super.absolute(n);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        super.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        super.beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        super.clearWarnings();
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_isOnInsertRow) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            if (0L == (this.m_updatableSupport & 1L)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULT_DELETE_NOT_SUPPORTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_resultSet.deleteRow();
            this.resetUpdateValues();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
        return super.first();
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1008;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getRow() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isOnInsertRow) {
            return 0;
        }
        return super.getRow();
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (0L == (this.m_updatableSupport & 2L)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULT_INSERT_NOT_SUPPORTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkForInvalidNulls(JDBCMessageKey.INVALID_NULL_INSERT, true);
            this.m_resultSet.appendRow();
            this.writeRow();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.isLast();
    }

    @Override
    public boolean last() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
        return super.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.resetUpdateValues();
            this.m_isOnInsertRow = false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.resetUpdateValues();
            this.m_isOnInsertRow = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
        return super.next();
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
        return super.previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        this.resetUpdateValues();
        return super.relative(n);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.m_isOnInsertRow) {
            return false;
        }
        return super.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.m_isOnInsertRow) {
            return false;
        }
        return super.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.m_isOnInsertRow) {
            return false;
        }
        return super.rowUpdated();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        super.setFetchDirection(n);
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        super.setFetchSize(n);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, array);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStreamImpl(n, inputStream, n2);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bigDecimal);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setNumeric(bigDecimal);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStreamImpl(n, inputStream, n2);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, blob);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bl);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setBoolean(bl);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setTinyInt(by);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, byArray);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setVarBinary(byArray);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateCharacterStreamImpl(n, reader, n2);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clob);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, date);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setDate(date);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, d);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setDouble(d);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, Float.valueOf(f));
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setReal(f);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setInteger(n2);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, l);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setBigInt(l);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateNull(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.checkIfValidRowNumber();
            this.clearStream(n);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(n - 1).getTypeMetadata();
            try {
                DataWrapper dataWrapper = new DataWrapper();
                dataWrapper.setNull(typeMetadata.getType());
                this.m_updateValues.set(n - 1, TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener));
                this.m_hasUpdateValues = true;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(typeMetadata.getType()));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.clearStream(n);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(n - 1).getTypeMetadata();
            DataWrapper dataWrapper = new DataWrapper();
            if (null == object) {
                dataWrapper.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType(dataWrapper2, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(object));
                }
            }
            this.m_updateValues.set(n - 1, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            Object object2;
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.clearStream(n);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(n - 1).getTypeMetadata();
            DataWrapper dataWrapper = new DataWrapper();
            if (null == object) {
                dataWrapper.setNull(typeMetadata.getType());
            } else {
                try {
                    object2 = new DataWrapper();
                    ((DataWrapper)object2).setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType((DataWrapper)object2, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(object));
                }
            }
            if (2 == dataWrapper.getType() || 3 == dataWrapper.getType()) {
                object2 = (BigDecimal)dataWrapper.getObject();
                dataWrapper.setData(dataWrapper.getType(), ((BigDecimal)object2).setScale(n2, 4));
            }
            this.m_updateValues.set(n - 1, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, ref);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (0L == (this.m_updatableSupport & 4L)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULT_UPDATE_NOT_SUPPORTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkForInvalidNulls(JDBCMessageKey.INVALID_NULL_UPDATE, false);
            this.m_resultSet.onStartRowUpdate();
            this.writeRow();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, s);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setSmallInt(s);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, string);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setVarChar(string);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setTime(time);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp);
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setTimestamp(timestamp);
            this.setValue(n, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected DataWrapper getData(int n, long l) throws SQLException {
        if (!this.m_isOnInsertRow) {
            return super.getData(n, l);
        }
        this.checkIfValidColumnNumber(n);
        if (0L == this.m_currentRow) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CURSOR_BEFORE_FIRST_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
        }
        DataWrapper dataWrapper = this.m_updateValues.get(n - 1);
        if (null != dataWrapper) {
            return dataWrapper;
        }
        if (null != this.m_updateStreamValues.get(n - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_GET_UPDATE_STREAM, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        try {
            dataWrapper = new DataWrapper();
            this.m_resultSet.getData(n - 1, 0L, l, dataWrapper);
            return dataWrapper;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void checkForInvalidNulls(JDBCMessageKey jDBCMessageKey, boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        for (int i = 0; i < this.m_updateValues.size(); ++i) {
            DataWrapper dataWrapper = this.m_updateValues.get(i);
            if (null != dataWrapper && !dataWrapper.isNull()) continue;
            AbstractDataStream abstractDataStream = this.m_updateStreamValues.get(i);
            if (null == abstractDataStream && 0 == resultSetMetaData.isNullable(i + 1)) {
                throw ExceptionConverter.getInstance().toSQLException(jDBCMessageKey, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(i + 1));
            }
            if (!bl || null != dataWrapper || null != abstractDataStream) continue;
            this.m_updateValues.set(i, new DataWrapper());
        }
    }

    protected void clearStream(int n) {
        AbstractDataStream abstractDataStream = this.m_updateStreamValues.get(n - 1);
        if (null != abstractDataStream) {
            abstractDataStream.close();
        }
        this.m_updateStreamValues.set(n - 1, null);
    }

    private void resetUpdateValues() {
        if (this.m_hasUpdateValues) {
            for (int i = 0; i < this.m_updateValues.size(); ++i) {
                this.m_updateValues.set(i, null);
                this.clearStream(i + 1);
            }
            this.m_hasUpdateValues = false;
        }
    }

    private void setStream(int n, AbstractDataStream abstractDataStream) throws SQLException, ErrorException {
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        this.checkIfValidRowNumber();
        this.clearStream(n);
        this.m_updateStreamValues.set(n - 1, abstractDataStream);
    }

    private void setValue(int n, DataWrapper dataWrapper) throws SQLException, ErrorException {
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        if (!this.m_isOnInsertRow) {
            this.checkIfValidRowNumber();
        }
        TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(n - 1).getTypeMetadata();
        this.clearStream(n);
        try {
            this.m_updateValues.set(n - 1, TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener));
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(typeMetadata.getType()));
        }
    }

    protected void updateAsciiStreamImpl(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, l);
            this.checkIfOpen();
            int n2 = this.m_resultMetaData.getColumnType(n);
            if (!TypeConverter.canConvertStreamTo(-1, n2)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
            }
            if (null == inputStream) {
                this.updateNull(n);
            } else {
                this.setStream(n, new AsciiDataStream(inputStream, l, n2, this.m_warningListener));
            }
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void updateBinaryStreamImpl(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, l);
            this.checkIfOpen();
            int n2 = this.m_resultMetaData.getColumnType(n);
            if (!TypeConverter.canConvertStreamTo(-4, n2)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
            }
            if (null == inputStream) {
                this.updateNull(n);
            } else {
                this.setStream(n, new BinaryDataStream(inputStream, l, n2, this.m_warningListener));
            }
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void updateCharacterStreamImpl(int n, Reader reader, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, reader, l);
            this.checkIfOpen();
            int n2 = this.m_resultMetaData.getColumnType(n);
            if (!TypeConverter.canConvertStreamTo(-1, n2)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
            }
            if (null == reader) {
                this.updateNull(n);
            } else {
                this.setStream(n, new CharacterDataStream(reader, l, n2, (IWarningListener)this.m_warningListener));
            }
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    private void writeRow() throws SQLException {
        try {
            for (int i = 0; i < this.m_updateValues.size(); ++i) {
                if (null != this.m_updateValues.get(i)) {
                    if (!this.m_resultSet.writeData(i, this.m_updateValues.get(i), 0L, false)) continue;
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DATA_TRUNCATED_ERR, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(i));
                }
                if (null == this.m_updateStreamValues.get(i)) continue;
                this.writeStream(i);
            }
            this.m_resultSet.onFinishRowUpdate();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
        this.resetUpdateValues();
    }

    private void writeStream(int n) throws ErrorException, SQLException {
        AbstractDataStream abstractDataStream = this.m_updateStreamValues.get(n);
        long l = 0L;
        while (abstractDataStream.hasMoreData()) {
            Pair<DataWrapper, Long> pair = abstractDataStream.getNextValue();
            if (this.m_resultSet.writeData(n, pair.key(), l, false)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DATA_TRUNCATED_ERR, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n + 1));
            }
            l += pair.value().longValue();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement.getResultSetHoldability();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string);
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public NClob getNClob(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string);
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public String getNString(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string);
        return this.getNString(this.findColumn(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public RowId getRowId(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string);
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string);
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return !this.m_isOpen || null == this.m_parentStatement;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.updateAsciiStream(n, inputStream, -1);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        this.updateAsciiStreamImpl(n, inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, l);
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStream(n, inputStream, -1);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStreamImpl(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStream(this.findColumn(string), inputStream, -1);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStreamImpl(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, inputStream);
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, inputStream, l);
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStream(n, reader, -1);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStreamImpl(n, reader, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStream(this.findColumn(string), reader, -1);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStreamImpl(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, reader);
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, reader, l);
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, reader);
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, reader, l);
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, nClob);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, nClob);
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, reader);
        this.updateNClob(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, reader, l);
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, string);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, string2);
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, rowId);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, rowId);
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, sQLXML);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, sQLXML);
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }
}

