/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.checkers.WarningReporterHelper;
import org.ohdsi.circe.check.operations.Execution;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;

public class ConceptSetCriteriaCheck
extends BaseCriteriaCheck {
    private static final String NO_CONCEPT_SET_ERROR = "No concept set specified as part of a criteria at %s in %s criteria";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void checkCriteria(Criteria criteria, String groupName, WarningReporter reporter) {
        WarningReporterHelper helper = new WarningReporterHelper(reporter, NO_CONCEPT_SET_ERROR, groupName);
        String criteriaName = CriteriaNameHelper.getCriteriaName(criteria);
        Execution addWarning = helper.addWarning(criteriaName);
        Operations.match(criteria).isA(ConditionEra.class).then(c -> Operations.match((ConditionEra)c).when(conditionEra -> Objects.isNull(conditionEra.codesetId)).then(addWarning)).isA(ConditionOccurrence.class).then(c -> Operations.match((ConditionOccurrence)c).when(conditionOccurrence -> Objects.isNull(conditionOccurrence.codesetId) && Objects.isNull(conditionOccurrence.conditionSourceConcept)).then(addWarning)).isA(Death.class).then(c -> Operations.match((Death)c).when(death -> Objects.isNull(death.codesetId)).then(addWarning)).isA(DeviceExposure.class).then(c -> Operations.match((DeviceExposure)c).when(deviceExposure -> Objects.isNull(deviceExposure.codesetId) && Objects.isNull(deviceExposure.deviceSourceConcept)).then(addWarning)).isA(DoseEra.class).then(c -> Operations.match((DoseEra)c).when(doseEra -> Objects.isNull(doseEra.codesetId)).then(addWarning)).isA(DrugEra.class).then(c -> Operations.match((DrugEra)c).when(drugEra -> Objects.isNull(drugEra.codesetId)).then(addWarning)).isA(DrugExposure.class).then(c -> Operations.match((DrugExposure)c).when(drugExposure -> Objects.isNull(drugExposure.codesetId) && Objects.isNull(drugExposure.drugSourceConcept)).then(addWarning)).isA(Measurement.class).then(c -> Operations.match((Measurement)c).when(measurement -> Objects.isNull(measurement.codesetId) && Objects.isNull(measurement.measurementSourceConcept)).then(addWarning)).isA(Observation.class).then(c -> Operations.match((Observation)c).when(observation -> Objects.isNull(observation.codesetId) && Objects.isNull(observation.observationSourceConcept)).then(addWarning)).isA(ProcedureOccurrence.class).then(c -> Operations.match((ProcedureOccurrence)c).when(procedureOccurrence -> Objects.isNull(procedureOccurrence.codesetId) && Objects.isNull(procedureOccurrence.procedureSourceConcept)).then(addWarning)).isA(Specimen.class).then(c -> Operations.match((Specimen)c).when(specimen -> Objects.isNull(specimen.codesetId) && Objects.isNull(specimen.specimenSourceConcept)).then(addWarning)).isA(VisitOccurrence.class).then(c -> Operations.match((VisitOccurrence)c).when(visitOccurrence -> Objects.isNull(visitOccurrence.codesetId) && Objects.isNull(visitOccurrence.visitSourceConcept)).then(addWarning)).isA(VisitDetail.class).then(c -> Operations.match((VisitDetail)c).when(visitDetail -> Objects.isNull(visitDetail.codesetId) && Objects.isNull(visitDetail.visitDetailSourceConcept)).then(addWarning));
    }
}

