/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class DensityRectangle {
    Rectangle2D rectangle;
    List<Point2D> points;
    int pointCount;
    double area;
    static int THRESHOLD = 80;
    DensityRectangle[] quadrants = null;

    public DensityRectangle(double d, double d2, double d3, double d4) {
        this.rectangle = new Rectangle2D.Double(d, d2, d3, d4);
        this.area = d3 * d4;
        this.points = new ArrayList<Point2D>();
    }

    public boolean contains(Point2D point2D) {
        return this.rectangle.contains(point2D);
    }

    public boolean contains(double d, double d2) {
        return this.rectangle.contains(d, d2);
    }

    public void addPoint(Point2D point2D) {
        if (this.contains(point2D)) {
            ++this.pointCount;
            if (this.quadrants == null) {
                this.points.add(point2D);
                if (this.points.size() > THRESHOLD) {
                    this.quadrants = new DensityRectangle[4];
                    double d = this.rectangle.getX();
                    double d2 = this.rectangle.getY();
                    double d3 = this.rectangle.getWidth() / 2.0;
                    double d4 = this.rectangle.getHeight() / 2.0;
                    this.quadrants[0] = new DensityRectangle(d, d2, d3, d4);
                    this.quadrants[1] = new DensityRectangle(d + d3, d2, d3, d4);
                    this.quadrants[2] = new DensityRectangle(d, d2 + d4, d3, d4);
                    this.quadrants[3] = new DensityRectangle(d + d3, d2 + d4, d3, d4);
                    for (Point2D point2D2 : this.points) {
                        this.quadrantPoint(point2D2);
                    }
                    this.points.clear();
                    this.points = null;
                }
            } else {
                this.quadrantPoint(point2D);
            }
        }
    }

    private void quadrantPoint(Point2D point2D) {
        boolean bl = false;
        for (int i = 0; i < this.quadrants.length && !bl; ++i) {
            if (!this.quadrants[i].contains(point2D)) continue;
            this.quadrants[i].addPoint(point2D);
            bl = true;
        }
        if (!bl) {
            throw new RuntimeException("Failed to quadrantize point!");
        }
    }

    public final double density() {
        return (double)this.getPointCount() / this.getArea();
    }

    public final double maximumDensity() {
        if (this.quadrants == null) {
            return this.density();
        }
        double d = this.quadrants[0].maximumDensity();
        for (int i = 1; i < this.quadrants.length; ++i) {
            double d2 = this.quadrants[i].maximumDensity();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public final int getPointCount() {
        return this.pointCount;
    }

    public final double getArea() {
        return this.area;
    }

    public final void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.paint(graphics2D, rectangle2D, this.maximumDensity());
    }

    private void paint(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        double d2 = this.density();
        float f = (float)(d2 / d);
        float f2 = 1.0f - f;
        float f3 = Math.min(f, f2);
        Color color = new Color(f, f3, f2);
        graphics2D.setColor(color);
        graphics2D.fill(rectangle2D);
        if (this.quadrants != null) {
            double d3 = rectangle2D.getX();
            double d4 = rectangle2D.getY();
            double d5 = rectangle2D.getWidth() / 2.0;
            double d6 = rectangle2D.getHeight() / 2.0;
            Rectangle2D[] rectangle2DArray = new Rectangle2D[]{new Rectangle2D.Double(d3, d4, d5, d6), new Rectangle2D.Double(d3 + d5, d4, d5, d6), new Rectangle2D.Double(d3, d4 + d6, d5, d6), new Rectangle2D.Double(d3 + d5, d4 + d6, d5, d6)};
            for (int i = 0; i < this.quadrants.length; ++i) {
                this.quadrants[i].paint(graphics2D, rectangle2DArray[i], d);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException, TraceException {
        int n;
        int n2 = 0;
        System.out.println("usage: densityPlot <logFileName> <xIndex> <yIndex> <maxX> <maxY>");
        String string = stringArray[0];
        int[] nArray = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i + 1]);
        }
        double d = Double.parseDouble(stringArray[3]);
        double d2 = Double.parseDouble(stringArray[4]);
        System.out.println("  logFileName=" + string);
        System.out.println("  xIndex=" + nArray[0]);
        System.out.println("  yIndex=" + nArray[1]);
        System.out.println("  maxX=" + d);
        System.out.println("  maxY=" + d2);
        File file = new File(string);
        LogFileTraces logFileTraces = new LogFileTraces(string, file);
        logFileTraces.loadTraces();
        logFileTraces.setBurnIn(n2);
        ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
        for (n = 0; n < 2; ++n) {
            arrayList.add(new ArrayList<Double>(logFileTraces.getValues(nArray[n])));
        }
        n = ((ArrayList)arrayList.get(0)).size();
        System.out.println("total samples = " + n);
        final DensityRectangle densityRectangle = new DensityRectangle(0.0, 0.0, d, d2);
        for (int i = 0; i < ((ArrayList)arrayList.get(0)).size(); ++i) {
            densityRectangle.addPoint(new Point2D.Double((Double)((ArrayList)arrayList.get(0)).get(i), (Double)((ArrayList)arrayList.get(1)).get(i)));
        }
        System.out.println("posterior prob visualized = " + (double)densityRectangle.getPointCount() / (double)n);
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 400);
        jFrame.getContentPane().add((Component)new JComponent(){
            private static final long serialVersionUID = -4045142094590087910L;

            @Override
            public void paintComponent(Graphics graphics) {
                Rectangle rectangle = this.getBounds();
                densityRectangle.paint((Graphics2D)graphics, rectangle);
            }
        }, "Center");
        jFrame.setVisible(true);
    }
}

