## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----install_packages, echo=FALSE, warning=FALSE, results='hide',message=FALSE----

###*****************************
# INITIAL COMMANDS TO RESET THE SYSTEM
seedNo=14159
set.seed(seedNo)
###*****************************

###*****************************
require("sicegar")
require("dplyr")
require("ggplot2")
require("cowplot")
###*****************************

## ----generate_data------------------------------------------------------------
time <- rep(seq(1, 24, 4), 5)
noise_parameter <- 0.3
mean_values <- doublesigmoidalFitFormula_h0(time,
                                       finalAsymptoteIntensityRatio = .3,
                                       maximum = 10,
                                       slope1Param = 1,
                                       midPoint1Param = 7,
                                       slope2Param = 1,
                                       midPointDistanceParam = 8,
                                       h0 = 3)
intensity <- rnorm(n = length(mean_values), mean = mean_values, sd = rep(noise_parameter, length(mean_values)))

dataInput <- data.frame(time, intensity)
ggplot(dataInput, aes(time, intensity)) + 
  geom_point() + 
  scale_y_continuous(limits = c(0, 12), expand = expansion(mult = c(0, 0))) + 
  theme_bw()

## -----------------------------------------------------------------------------
try({
fitObj <- fitAndCategorize(dataInput,
                           threshold_minimum_for_intensity_maximum = 0.3,
                           threshold_intensity_range = 0.1,
                           threshold_t0_max_int = 1E10,
                           use_h0 = TRUE)
})

## -----------------------------------------------------------------------------
dataInput_jitter <- dataInput |>
  mutate(time = jitter(time, amount = 0.5))
  
ggplot(dataInput_jitter, aes(time, intensity)) + 
  geom_point() + 
  scale_y_continuous(limits = c(0, 12), expand = expansion(mult = c(0, 0))) + 
  theme_bw()

## -----------------------------------------------------------------------------
fitObj_jittered <- fitAndCategorize(dataInput_jitter,
                           threshold_minimum_for_intensity_maximum = 0.3,
                           threshold_intensity_range = 0.1,
                           threshold_t0_max_int = 1E10,
                           use_h0 = TRUE)

figureModelCurves(dataInput = fitObj_jittered$normalizedInput,
                  doubleSigmoidalFitVector = fitObj_jittered$doubleSigmoidalModel,
                  showParameterRelatedLines = TRUE,
                  use_h0 = TRUE)

## -----------------------------------------------------------------------------
time <- seq(1, 24, 0.5)
noise_parameter <- 0.2
mean_values <- doublesigmoidalFitFormula_h0(time,
                                       finalAsymptoteIntensityRatio = .3,
                                       maximum = 10,
                                       slope1Param = 1,
                                       midPoint1Param = 7,
                                       slope2Param = 1,
                                       midPointDistanceParam = 8,
                                       h0 = 8)
intensity <- rnorm(n = length(mean_values), mean = mean_values, sd = rep(noise_parameter, length(mean_values)))

dataInput <- data.frame(time, intensity)
ggplot(dataInput, aes(time, intensity)) + 
  geom_point() + 
  scale_y_continuous(limits = c(0, 12), expand = expansion(mult = c(0, 0))) + 
  theme_bw()

## -----------------------------------------------------------------------------
dataInput_flipped <- dataInput |>
  mutate(time = max(time) - time)

ggplot(dataInput_flipped, aes(time, intensity)) + 
  geom_point() + 
  scale_y_continuous(limits = c(0, 12), expand = expansion(mult = c(0, 0))) + 
  theme_bw()

## -----------------------------------------------------------------------------
fitObj_flipped <- fitAndCategorize(dataInput_flipped,
                           threshold_minimum_for_intensity_maximum = 0.3,
                           threshold_intensity_range = 0.1,
                           threshold_t0_max_int = 1E10,
                           use_h0 = TRUE)

figureModelCurves(dataInput = fitObj_flipped$normalizedInput,
                  doubleSigmoidalFitVector = fitObj_flipped$doubleSigmoidalModel,
                  showParameterRelatedLines = TRUE,
                  use_h0 = TRUE)

## -----------------------------------------------------------------------------
original_onset_time <- max(dataInput$time) - fitObj_flipped$doubleSigmoidalModel$midPoint1Param_Estimate

dataInput <- data.frame(time, intensity)
ggplot(dataInput, aes(time, intensity)) + 
  geom_point() + 
  geom_vline(xintercept = original_onset_time, color = "red", linetype = "dashed") +
  scale_y_continuous(limits = c(0, 12), expand = expansion(mult = c(0, 0))) + 
  theme_bw()

