/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.text.DecimalFormat;
import org.vikamine.kernel.statistics.StatisticComponent;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;

public class SGVerbalizer {
    protected String delimeter = "\t";
    protected DecimalFormat formatter = new DecimalFormat("#.###");
    public static final int SGQuality = 1;
    public static final int SGSize = 2;
    public static final int SGTargetQuantity = 4;
    public static final int SGDeviation = 8;
    public static final int TP = 16;
    public static final int SIGNIFICANCE = 32;

    public SGVerbalizer() {
    }

    public SGVerbalizer(DecimalFormat decimalFormatter) {
        this.formatter = decimalFormatter;
    }

    public SGVerbalizer(String delimeter) {
        this.delimeter = delimeter;
    }

    public SGVerbalizer(String delimeter, DecimalFormat decimalFormatter) {
        this.delimeter = delimeter;
        this.formatter = decimalFormatter;
    }

    public String getDelimeter() {
        return this.delimeter;
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    public void setDelimeter(String delimeter) {
        this.delimeter = delimeter;
    }

    public void setFormatter(DecimalFormat formatter) {
        this.formatter = formatter;
    }

    public String verbalize(SG sg, int parameter) {
        StringBuilder sb = new StringBuilder();
        String description = sg.getDescription().getDescription();
        sb.append(description.isEmpty() ? "Overall" : description);
        if ((parameter & 1) > 0) {
            sb.append(String.valueOf(this.delimeter) + this.formatter.format(sg.getQuality()));
        }
        if ((parameter & 2) > 0) {
            sb.append(String.valueOf(this.delimeter) + sg.getStatistics().getSubgroupSize());
        }
        if ((parameter & 4) > 0) {
            if (sg.getStatistics() instanceof SGStatisticsBinary) {
                sb.append(String.valueOf(this.delimeter) + this.formatter.format(((SGStatisticsBinary)sg.getStatistics()).getP()));
            } else if (sg.getStatistics() instanceof SGStatisticsNumeric) {
                sb.append(String.valueOf(this.delimeter) + this.formatter.format(((SGStatisticsNumeric)sg.getStatistics()).getSGMean()));
            } else {
                sb.append(String.valueOf(this.delimeter) + "-");
            }
        }
        if ((parameter & 8) > 0) {
            sb.append(String.valueOf(this.delimeter) + this.formatter.format(sg.getStatistics().getDeviation()));
        }
        if ((parameter & 0x10) > 0 && sg.getTarget().isBoolean()) {
            sb.append(String.valueOf(this.delimeter) + this.formatter.format(((SGStatisticsBinary)sg.getStatistics()).getTp()));
        }
        if ((parameter & 0x20) > 0 && sg.getTarget().isBoolean()) {
            StatisticComponent.Significance signifComponent = StatisticComponent.SIGNIFICANCE;
            sb.append(String.valueOf(this.delimeter) + ((StatisticComponent)signifComponent).getValue(sg.getStatistics()));
        }
        this.addAdditionalParameters(sg, sb);
        return sb.toString();
    }

    protected void addAdditionalParameters(SG sg, StringBuilder sb) {
    }

    public String verbalize(Iterable<SG> sgs, int parameter) {
        StringBuilder sb = new StringBuilder();
        SG firstSG = sgs.iterator().next();
        sb.append("Description");
        if ((parameter & 1) > 0) {
            sb.append(String.valueOf(this.delimeter) + "Quality");
        }
        if ((parameter & 2) > 0) {
            sb.append(String.valueOf(this.delimeter) + "Size");
        }
        if ((parameter & 4) > 0) {
            sb.append(String.valueOf(this.delimeter) + "Target");
        }
        if ((parameter & 8) > 0) {
            sb.append(String.valueOf(this.delimeter) + "Deviation target");
        }
        if ((parameter & 0x10) > 0 && firstSG.getTarget().isBoolean()) {
            sb.append(String.valueOf(this.delimeter) + "True Positives");
        }
        if ((parameter & 0x20) > 0 && firstSG.getTarget().isBoolean()) {
            sb.append(String.valueOf(this.delimeter) + "Significance");
        }
        sb.append("\n");
        for (SG sg : sgs) {
            sb.append(String.valueOf(this.verbalize(sg, parameter)) + "\n");
        }
        return sb.toString();
    }
}

