/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.NumericTarget;

public final class SGSets {
    private static final double EPSILON = 0.05;

    public static SGSet copySGSet(SGSet sgSet) {
        AbstractSGSet newSGSet = null;
        if (sgSet instanceof SGSetImpl) {
            newSGSet = new SGSetImpl();
            newSGSet.initWith(sgSet);
        } else if (sgSet instanceof KBestSGSet) {
            newSGSet = new KBestSGSetImpl();
            ((KBestSGSetImpl)newSGSet).initWith(sgSet);
        }
        return newSGSet;
    }

    public static KBestSGSet createKBestSGSet(int maxSGCount, double sgMinQualityLimit) {
        KBestSGSetImpl kBestSGSet = new KBestSGSetImpl();
        kBestSGSet.setMaxSGCount(maxSGCount);
        kBestSGSet.setSGMinQualityLimit(sgMinQualityLimit);
        return kBestSGSet;
    }

    public static SGSet createSGSet() {
        return new SGSetImpl();
    }

    private static List extractFP(SG sg) {
        LinkedList<DataRecord> fps = new LinkedList<DataRecord>();
        Iterator<DataRecord> iter = sg.subgroupInstanceIterator();
        while (iter.hasNext()) {
            DataRecord inst = iter.next();
            if (sg.getTarget() instanceof BooleanTarget && !((BooleanTarget)sg.getTarget()).isPositive(inst)) {
                fps.add(inst);
                continue;
            }
            if (!(sg.getTarget() instanceof NumericTarget)) continue;
            fps.add(inst);
        }
        return fps;
    }

    private static List extractTP(SG sg) {
        LinkedList<DataRecord> tps = new LinkedList<DataRecord>();
        Iterator<DataRecord> iter = sg.subgroupInstanceIterator();
        while (iter.hasNext()) {
            DataRecord inst = iter.next();
            if (sg.getTarget() instanceof BooleanTarget && ((BooleanTarget)sg.getTarget()).isPositive(inst)) {
                tps.add(inst);
                continue;
            }
            if (!(sg.getTarget() instanceof NumericTarget)) continue;
            tps.add(inst);
        }
        return tps;
    }

    private static boolean isSGStrictlyIrrelevant(SG newSG, SG referenceSG) {
        if (newSG.getTarget().isNumeric() || referenceSG.getTarget().isNumeric()) {
            throw new IllegalArgumentException("Relevance check can only be performed for boolean targets");
        }
        double newSGTPCount = ((SGStatisticsBinary)newSG.getStatistics()).getTp();
        double newSGFPCount = ((SGStatisticsBinary)newSG.getStatistics()).getFp();
        double referenceSGTPCount = ((SGStatisticsBinary)referenceSG.getStatistics()).getTp();
        double referenceSGFPCount = ((SGStatisticsBinary)referenceSG.getStatistics()).getFp();
        if (referenceSGFPCount != 0.0 && (newSGTPCount > referenceSGTPCount || newSGFPCount < referenceSGFPCount)) {
            return false;
        }
        List newSGTP = SGSets.extractTP(newSG);
        List newSGFP = SGSets.extractFP(newSG);
        List referenceSGTP = SGSets.extractTP(referenceSG);
        List referenceSGFP = SGSets.extractFP(referenceSG);
        if (newSGFPCount == 0.0 && referenceSGFPCount == 0.0 && referenceSGTP.containsAll(newSGTP)) {
            if (newSG.getSGDescription().size() < referenceSG.getSGDescription().size()) {
                return false;
            }
            return newSG.getSGDescription().size() != referenceSG.getSGDescription().size() || !(newSG.getStatistics().getDefinedPopulationCount() > referenceSG.getStatistics().getDefinedPopulationCount());
        }
        if (referenceSGTP.containsAll(newSGTP) && newSGFP.containsAll(referenceSGFP)) {
            if (newSGTPCount == referenceSGTPCount && newSGFPCount == referenceSGFPCount) {
                if (newSG.getSGDescription().size() < referenceSG.getSGDescription().size()) {
                    return false;
                }
                return newSG.getSGDescription().size() != referenceSG.getSGDescription().size() || !(newSG.getStatistics().getDefinedPopulationCount() > referenceSG.getStatistics().getDefinedPopulationCount());
            }
            return true;
        }
        return false;
    }

    private static boolean isSGStrictlyIrrelevant(SG newSG, SG referenceSG, int epsilon) {
        int fpExceptions;
        if (newSG.getTarget().isNumeric() || referenceSG.getTarget().isNumeric()) {
            throw new IllegalArgumentException("Relevance check can only be performed for boolean targets");
        }
        double newSGTPCount = ((SGStatisticsBinary)newSG.getStatistics()).getTp();
        double newSGFPCount = ((SGStatisticsBinary)newSG.getStatistics()).getFp();
        double referenceSGTPCount = ((SGStatisticsBinary)referenceSG.getStatistics()).getTp();
        double referenceSGFPCount = ((SGStatisticsBinary)referenceSG.getStatistics()).getFp();
        List newSGTP = SGSets.extractTP(newSG);
        List newSGFP = SGSets.extractFP(newSG);
        List referenceSGTP = SGSets.extractTP(referenceSG);
        List referenceSGFP = SGSets.extractFP(referenceSG);
        int tpExceptions = SGSets.numberOfContainsAllExceptions(referenceSGTP, newSGTP);
        if (tpExceptions + (fpExceptions = SGSets.numberOfContainsAllExceptions(newSGFP, referenceSGFP)) <= epsilon) {
            if (newSGTPCount == referenceSGTPCount && newSGFPCount == referenceSGFPCount) {
                if (newSG.getSGDescription().size() < referenceSG.getSGDescription().size()) {
                    return false;
                }
                return newSG.getSGDescription().size() != referenceSG.getSGDescription().size() || !(newSG.getStatistics().getDefinedPopulationCount() > referenceSG.getStatistics().getDefinedPopulationCount());
            }
            return true;
        }
        return false;
    }

    public static boolean isSGStrictlyIrrelevant(SG newSG, Iterable<SG> sgSet) {
        for (SG refSG : sgSet) {
            if (newSG.equals(refSG) || !SGSets.isSGStrictlyIrrelevant(newSG, refSG)) continue;
            return true;
        }
        return false;
    }

    public static SGSet mergeSGSetsToKBestSGSet(List<SGSet> multipleSets, int maxSGCount, double minQualitylimit) {
        if (multipleSets == null) {
            throw new IllegalArgumentException("try to merge null SGset");
        }
        KBestSGSet result = SGSets.createKBestSGSet(maxSGCount, minQualitylimit);
        for (SGSet s : multipleSets) {
            for (SG sg : s) {
                if (!result.isInKBestQualityRange(sg.getQuality())) continue;
                result.addByReplacingWorstSG(sg);
            }
        }
        return result;
    }

    private static int numberOfContainsAllExceptions(List containingList, List containedList) {
        int exceptionCounter = 0;
        for (Object o : containedList) {
            if (containingList.contains(o)) continue;
            ++exceptionCounter;
        }
        return exceptionCounter;
    }

    public static void removeEmptySubgroupsFromSGSet(SGSet sgSet) {
        Iterator<SG> iter = sgSet.iterator();
        while (iter.hasNext()) {
            SG sg = iter.next();
            if (!sg.getSGDescription().isEmpty()) continue;
            iter.remove();
        }
    }

    public static void removeIrrelevantSubgroupsFromSGSet(int epsilon, SGSet sgSet) {
        LinkedList<SG> sgsToRemove = new LinkedList<SG>();
        int i = 0;
        for (SG sg : sgSet) {
            for (SG sgTest : sgSet) {
                if (sg.equals(sgTest) || sgsToRemove.contains(sgTest) || sgsToRemove.contains(sg) || !SGSets.isSGStrictlyIrrelevant(sgTest, sg, epsilon)) continue;
                sgsToRemove.add(sgTest);
            }
            System.out.print(";" + i);
            ++i;
        }
        sgSet.removeAll(sgsToRemove);
        System.out.println();
    }

    public static void removeIrrelevantSubgroupsFromSGSet(SGSet sgSet) {
        LinkedList<SG> sgsToRemove = new LinkedList<SG>();
        for (SG sg : sgSet) {
            for (SG sgTest : sgSet) {
                if (sg.equals(sgTest) || sgsToRemove.contains(sgTest) || sgsToRemove.contains(sg) || !SGSets.isSGStrictlyIrrelevant(sgTest, sg)) continue;
                sgsToRemove.add(sgTest);
            }
        }
        sgSet.removeAll(sgsToRemove);
    }

    public static void removeSubgroupsIrrelevantTo(SG sg, SGSet sgSet) {
        LinkedList<SG> sgsToRemove = new LinkedList<SG>();
        for (SG sgTest : sgSet) {
            if (sg.equals(sgTest) || sgsToRemove.contains(sgTest) || !SGSets.isSGStrictlyIrrelevant(sgTest, sg)) continue;
            sgsToRemove.add(sgTest);
        }
        sgSet.removeAll(sgsToRemove);
    }

    public static double getQualitySum(SGSet set) {
        double result = 0.0;
        for (SG sg : set) {
            result += sg.getQuality();
        }
        return result;
    }

    private SGSets() {
    }

    public static boolean haveEquivalentQualities(SGSet thisSet, SGSet otherSet) {
        return SGSets.hasPairwiseBetterQuality(thisSet, otherSet) && SGSets.hasPairwiseBetterQuality(otherSet, thisSet);
    }

    public static boolean hasPairwiseBetterQuality(SGSet thisSet, SGSet otherSet) {
        List<SG> thisSorted = thisSet.toSortedList(false);
        List<SG> otherSorted = otherSet.toSortedList(false);
        if (otherSorted.size() > thisSorted.size()) {
            return false;
        }
        int i = 0;
        while (i < thisSorted.size()) {
            if (thisSorted.get(i).getQuality() - otherSorted.get(i).getQuality() > 0.05) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static abstract class AbstractSGSet
    implements SGSet {
        protected List<SG> subgroups = new ArrayList<SG>();
        protected double maxSGQuality = Double.POSITIVE_INFINITY;
        protected double minSGQuality = Double.NEGATIVE_INFINITY;
        private String name;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.subgroups == null ? 0 : this.subgroups.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractSGSet other = (AbstractSGSet)obj;
            return !(this.subgroups == null ? other.subgroups != null : !this.subgroups.equals(other.subgroups));
        }

        protected AbstractSGSet() {
        }

        @Override
        public void add(SG subgroup) {
            if (!this.contains(subgroup)) {
                this.addSGInternal(subgroup);
                this.recalculateQualities();
            }
        }

        @Override
        public void addAll(Iterable<SG> subgroups) {
            for (SG o : subgroups) {
                SG sg;
                if (!(o instanceof SG) || this.contains(sg = o)) continue;
                this.addSGInternal(sg);
            }
            this.recalculateQualities();
        }

        protected void addSGInternal(SG subgroup) {
            this.subgroups.add(subgroup);
        }

        @Override
        public boolean contains(SG otherSG) {
            return this.subgroups.contains(otherSG);
        }

        @Override
        public double getMaxSGQuality() {
            return this.maxSGQuality;
        }

        @Override
        public double getMaxSubgroupSize() {
            double maxSubgroupSize = 0.0;
            for (SG sg : this.subgroups) {
                maxSubgroupSize = Math.max(sg.getStatistics().getSubgroupSize(), maxSubgroupSize);
            }
            return maxSubgroupSize;
        }

        @Override
        public double getMinSGQuality() {
            return this.minSGQuality;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Iterator<SG> iterator() {
            return new SubgroupsIterator(this);
        }

        protected void recalculateQualities() {
            if (this.subgroups == null || this.subgroups.isEmpty()) {
                this.maxSGQuality = Double.NEGATIVE_INFINITY;
                this.minSGQuality = Double.POSITIVE_INFINITY;
            } else {
                double firstSGQuality;
                this.maxSGQuality = firstSGQuality = this.subgroups.get(0).getQuality();
                this.minSGQuality = firstSGQuality;
                for (SG sg : this.subgroups) {
                    if (sg.getQuality() > this.maxSGQuality) {
                        this.maxSGQuality = sg.getQuality();
                    }
                    if (!(sg.getQuality() < this.minSGQuality)) continue;
                    this.minSGQuality = sg.getQuality();
                }
            }
        }

        @Override
        public List<SG> toSortedList(boolean ascending) {
            ArrayList<SG> result = new ArrayList<SG>(this.subgroups);
            final boolean finalInvert = ascending;
            Collections.sort(result, new Comparator<SG>(){

                @Override
                public int compare(SG sg1, SG sg2) {
                    int result = Double.compare(sg1.getQuality(), sg2.getQuality());
                    return finalInvert ? result : -result;
                }
            });
            return result;
        }

        @Override
        public void remove(SG sg) {
            this.subgroups.remove(sg);
            this.recalculateQualities();
        }

        @Override
        public void removeAll(Iterable<SG> sgs) {
            Iterator<SG> iter = sgs.iterator();
            while (iter.hasNext()) {
                this.subgroups.remove(iter.next());
            }
            this.recalculateQualities();
        }

        @Override
        public void setName(String string) {
            this.name = string;
        }

        @Override
        public int size() {
            return this.subgroups.size();
        }

        public String toString() {
            return "SGSet (" + this.minSGQuality + ", " + this.maxSGQuality + ") - subgroups: " + this.subgroups.toString();
        }

        @Override
        public SGSet sortSubgroupsByQualityDescending() {
            AbstractSGSet sgSet = (AbstractSGSet)SGSets.copySGSet(this);
            Collections.sort(sgSet.subgroups, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof SG && o2 instanceof SG) {
                        double q1 = ((SG)o1).getQuality();
                        double q2 = ((SG)o2).getQuality();
                        return -1 * Double.compare(q1, q2);
                    }
                    throw new RuntimeException("No SG element in SGSet!");
                }

                @Override
                public boolean equals(Object obj) {
                    return super.equals(obj);
                }

                public int hashCode() {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return 42;
                }
            });
            return sgSet;
        }

        private static class SubgroupsIterator
        implements Iterator<SG> {
            private final AbstractSGSet abstractSGSet;
            private final Iterator<SG> innerIterator;

            public SubgroupsIterator(SGSet sgSet) {
                this.abstractSGSet = (AbstractSGSet)sgSet;
                this.innerIterator = this.abstractSGSet.subgroups.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext();
            }

            @Override
            public SG next() {
                return this.innerIterator.next();
            }

            @Override
            public void remove() {
                this.innerIterator.remove();
                this.abstractSGSet.recalculateQualities();
            }
        }
    }

    private static class KBestSGSetImpl
    extends AbstractSGSet
    implements KBestSGSet {
        private double sgMinQualityLimit = Double.NEGATIVE_INFINITY;
        private int maxSGCount = Integer.MAX_VALUE;

        @Override
        public void addByReplacingWorstSG(SG betterSG) {
            if (!this.contains(betterSG)) {
                if (this.subgroups.size() >= this.getMaxSGCount()) {
                    SG worstSG = betterSG;
                    double worstQuality = betterSG.getQuality();
                    for (SG sg : this.subgroups) {
                        if (!(sg.getQuality() < worstQuality)) continue;
                        worstSG = sg;
                        worstQuality = sg.getQuality();
                    }
                    this.subgroups.remove(worstSG);
                }
                this.addSGInternal(betterSG);
                this.recalculateQualities();
            }
        }

        @Override
        public int getMaxSGCount() {
            return this.maxSGCount;
        }

        @Override
        public double getQualitySum() {
            double quality = 0.0;
            for (SG sg : this) {
                quality += sg.getQuality();
            }
            return quality;
        }

        @Override
        public double getSGMinQualityLimit() {
            return this.sgMinQualityLimit;
        }

        @Override
        public void initWith(SGSet sgSet) {
            this.subgroups.addAll(sgSet.toSortedList(false));
            this.maxSGQuality = sgSet.getMaxSGQuality();
            this.minSGQuality = sgSet.getMinSGQuality();
            if (sgSet instanceof KBestSGSet) {
                KBestSGSet kBestSGSet = (KBestSGSet)sgSet;
                this.setMaxSGCount(kBestSGSet.getMaxSGCount());
                this.setSGMinQualityLimit(kBestSGSet.getSGMinQualityLimit());
            }
        }

        @Override
        public boolean isInKBestQualityRange(double quality) {
            if (quality >= this.getSGMinQualityLimit()) {
                if (this.subgroups.size() < this.getMaxSGCount()) {
                    return true;
                }
                return quality > this.getMinSGQuality();
            }
            return false;
        }

        protected void setMaxSGCount(int maxNumberOfSubgroups) {
            this.maxSGCount = maxNumberOfSubgroups;
        }

        protected void setSGMinQualityLimit(double minSGQualityLimit) {
            this.sgMinQualityLimit = minSGQualityLimit;
        }

        @Override
        public String toComprehensiveString() {
            String result = "SGSet (" + this.minSGQuality + ", " + this.maxSGQuality + ") - subgroups: \n";
            for (SG sg : this.subgroups) {
                result = String.valueOf(result) + "q: (" + sg.getQuality() + ") \t" + sg.getSGDescription() + "\n";
            }
            return result;
        }
    }

    private static class SGSetImpl
    extends AbstractSGSet {
        @Override
        public void initWith(SGSet sgSet) {
            this.subgroups.addAll(sgSet.toSortedList(false));
            this.maxSGQuality = sgSet.getMaxSGQuality();
            this.minSGQuality = sgSet.getMinSGQuality();
        }
    }
}

