/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.SupervisedBinaryDiscretizer;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class ZetaDiscretizer
extends SupervisedBinaryDiscretizer {
    private static final String NAME = "Zeta Discretizer";
    private static final String REC_DEPTH = "rec-depth";
    private static final String THRESHOLD = "threshold";
    private static final int DEF_RECDEPTH = 3;
    private static final double DEF_THRESHOLD = 0.0;
    private int recDepth = 3;
    private double threshold = 0.0;

    public ZetaDiscretizer() {
    }

    public ZetaDiscretizer(SGTarget target) {
        super(target);
    }

    public ZetaDiscretizer(DataView population, NumericAttribute na, int segCount, SGTarget target) {
        super(target);
        this.setPopulation(population);
        this.setAttribute(na);
        this.setSegmentsCount(segCount);
    }

    private static int zeta(int negativesLower, int positivesLower, int negativesUpper, int positivesUpper) {
        return Math.max(negativesLower + positivesUpper, positivesLower + negativesUpper);
    }

    public ZetaDiscretizer(String[] args) {
        this();
        int i = 1;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg[0].contains(REC_DEPTH)) {
                this.recDepth = Integer.parseInt(arg[1].trim());
            } else if (arg[0].contains(THRESHOLD)) {
                this.threshold = Double.parseDouble(arg[1].trim());
            }
            ++i;
        }
    }

    @Override
    public void setSegmentsCount(int segmentsCount) {
        this.recDepth = (int)Math.ceil(Math.log(segmentsCount) / Math.log(2.0));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    SupervisedBinaryDiscretizer.BinaryPartition makeBinaryPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
        return new ZetaPartition(firstBlock, lastBlock, this.recDepth);
    }

    private final class ZetaPartition
    extends SupervisedBinaryDiscretizer.BinaryPartition {
        private ZetaPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, int recursions) {
            this(firstBlock, null, lastBlock, recursions);
        }

        private ZetaPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, int recursions) {
            if (recursions-- == 0) {
                return;
            }
            this.isAccepted = true;
            this.cutPoint = this.bestCutPoint(firstBlock.upperBoundary, null, upperBoundary, lastBlock);
            if (this.cutPoint == null) {
                return;
            }
            this.lowerPartition = new ZetaPartition(firstBlock, this.cutPoint, lastBlock, recursions);
            this.upperPartition = new ZetaPartition(this.cutPoint, upperBoundary, lastBlock, recursions);
        }

        private ZetaPartition(SupervisedBinaryDiscretizer.BoundaryPoint lowerBoundary, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, int recursions) {
            if (recursions-- == 0) {
                return;
            }
            this.isAccepted = true;
            this.cutPoint = this.bestCutPoint(lowerBoundary.nextCutPoint(), lowerBoundary, upperBoundary, lastBlock);
            if (this.cutPoint == null) {
                return;
            }
            this.lowerPartition = new ZetaPartition(lowerBoundary, this.cutPoint, lastBlock, recursions);
            this.upperPartition = new ZetaPartition(this.cutPoint, upperBoundary, lastBlock, recursions);
        }

        private SupervisedBinaryDiscretizer.BoundaryPoint bestCutPoint(SupervisedBinaryDiscretizer.BoundaryPoint start, SupervisedBinaryDiscretizer.BoundaryPoint lowerBoundary, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
            int maxZeta = Integer.MIN_VALUE;
            SupervisedBinaryDiscretizer.BoundaryPoint bestCutPoint = null;
            SupervisedBinaryDiscretizer.BoundaryPoint cutPoint = start;
            while (cutPoint != upperBoundary) {
                int zeta = ZetaDiscretizer.zeta(cutPoint.sumNegativesLowerCut(lowerBoundary), cutPoint.sumPositivesLowerCut(lowerBoundary), cutPoint.sumNegativesUpperCut(upperBoundary, lastBlock), cutPoint.sumPositivesUpperCut(upperBoundary, lastBlock));
                if (zeta > maxZeta) {
                    maxZeta = zeta;
                    bestCutPoint = cutPoint;
                }
                cutPoint = cutPoint.nextCutPoint();
            }
            if ((double)maxZeta / (double)ZetaPartition.size(lowerBoundary, upperBoundary, lastBlock) < ZetaDiscretizer.this.threshold) {
                return null;
            }
            return bestCutPoint;
        }
    }
}

