/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.DayOfWeek;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.timeseries.calendars.HolidaysUtility;

class CalendarCorrector
implements HolidaysCorrectedTradingDays.HolidaysCorrector {
    final Holiday[] holidays;
    final boolean meanCorrection;
    final DayOfWeek hol;

    CalendarCorrector(Holiday[] holidays, boolean meanCorrection, DayOfWeek hol) {
        this.holidays = holidays;
        this.meanCorrection = meanCorrection;
        this.hol = hol;
    }

    public Matrix rawCorrection(TsDomain domain) {
        int phol = this.hol.getValue() - 1;
        Matrix C = HolidaysUtility.holidays(this.holidays, domain);
        FastMatrix Cc = FastMatrix.of(C);
        DataBlock chol = Cc.column(phol);
        chol.set(0.0);
        for (int i = 0; i < 7; ++i) {
            if (i == phol) continue;
            DataBlock cur = Cc.column(i);
            chol.add(cur);
            cur.chs();
        }
        return Cc;
    }

    public Matrix holidaysCorrection(TsDomain domain) {
        int i;
        int phol = this.hol.getValue() - 1;
        Matrix C = HolidaysUtility.holidays(this.holidays, domain);
        FastMatrix Cc = FastMatrix.of(C);
        if (this.meanCorrection) {
            FastMatrix LT = HolidaysUtility.longTermMean(this.holidays, domain);
            for (i = 0; i < Cc.getColumnsCount(); ++i) {
                Cc.column(i).sub(LT.column(i));
            }
        }
        DataBlock chol = Cc.column(phol);
        chol.set(0.0);
        for (i = 0; i < 7; ++i) {
            if (i == phol) continue;
            DataBlock cur = Cc.column(i);
            chol.add(cur);
            cur.chs();
        }
        return Cc;
    }

    public DoubleSeq longTermYearlyCorrection() {
        int i2;
        if (this.holidays.length == 0) {
            return DoubleSeq.onMapping((int)7, i -> 0.0);
        }
        double[][] corr = HolidaysUtility.longTermMean(this.holidays, 1);
        double[] c = corr[0];
        double sum = 0.0;
        int ihol = this.hol.getValue() - 1;
        for (i2 = 0; i2 < c.length; ++i2) {
            if (i2 == ihol) continue;
            sum += c[i2];
        }
        for (i2 = 0; i2 < c.length; ++i2) {
            c[i2] = i2 != ihol ? -c[i2] : sum;
        }
        return DoubleSeq.of((double[])c);
    }
}

