/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;

public interface IDoubleBondStereochemistry
extends IStereoElement<IBond, IBond> {
    public IBond[] getBonds();

    public IBond getStereoBond();

    public Conformation getStereo();

    @Override
    public IDoubleBondStereochemistry map(Map<IAtom, IAtom> var1, Map<IBond, IBond> var2);

    public static enum Conformation {
        TOGETHER,
        OPPOSITE;


        public static Conformation toConformation(int config) {
            switch (config) {
                case 2: {
                    return TOGETHER;
                }
                case 1: {
                    return OPPOSITE;
                }
            }
            throw new IllegalArgumentException("Cannot map config to enum: " + config);
        }

        public static int toConfig(Conformation conformation) {
            switch (conformation) {
                case TOGETHER: {
                    return 2;
                }
                case OPPOSITE: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Cannot map enum to config: " + (Object)((Object)conformation));
        }

        public Conformation invert() {
            switch (this) {
                case TOGETHER: {
                    return OPPOSITE;
                }
                case OPPOSITE: {
                    return TOGETHER;
                }
            }
            return this;
        }
    }
}

