/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.BIOTokenizationFilter;
import cc.mallet.extract.Element;
import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.extract.Span;
import cc.mallet.extract.StringSpan;
import cc.mallet.extract.Text;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Sequence;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DocumentExtraction
implements Serializable {
    private Tokenization input;
    private Sequence predictedLabels;
    private LabelSequence target;
    private LabeledSpans extractedSpans;
    private LabeledSpans targetSpans;
    private Object document;
    private Label backgroundTag;
    private String name;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public DocumentExtraction(String name, LabelAlphabet dict, Tokenization input, Sequence predicted, String background) {
        this(name, dict, input, predicted, null, background, new BIOTokenizationFilter());
    }

    public DocumentExtraction(String name, LabelAlphabet dict, Tokenization input, Sequence predicted, Sequence target, String background) {
        this(name, dict, input, predicted, target, background, new BIOTokenizationFilter());
    }

    public DocumentExtraction(String name, LabelAlphabet dict, Tokenization input, Sequence predicted, Sequence target, String background, TokenizationFilter filter) {
        this.document = input.getDocument();
        this.name = name;
        assert (input.size() == predicted.size());
        this.backgroundTag = dict.lookupLabel(background);
        this.input = input;
        this.predictedLabels = predicted;
        this.extractedSpans = filter.constructLabeledSpans(dict, this.document, this.backgroundTag, input, predicted);
        if (target != null) {
            if (target instanceof LabelSequence) {
                this.target = (LabelSequence)target;
            }
            this.targetSpans = filter.constructLabeledSpans(dict, this.document, this.backgroundTag, input, target);
        }
    }

    public DocumentExtraction(String name, LabelAlphabet dict, Tokenization input, LabeledSpans predictedSpans, LabeledSpans trueSpans, String background) {
        this.document = input.getDocument();
        this.name = name;
        this.backgroundTag = dict.lookupLabel(background);
        this.input = input;
        this.extractedSpans = predictedSpans;
        this.targetSpans = trueSpans;
    }

    public Object getDocument() {
        return this.document;
    }

    public Tokenization getInput() {
        return this.input;
    }

    public Sequence getPredictedLabels() {
        return this.predictedLabels;
    }

    public LabeledSpans getExtractedSpans() {
        return this.extractedSpans;
    }

    public LabeledSpans getTargetSpans() {
        return this.targetSpans;
    }

    public LabelSequence getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    public Label getBackgroundTag() {
        return this.backgroundTag;
    }

    public Span subspan(int start, int end) {
        throw new UnsupportedOperationException("not yet implemented.");
    }

    public Element toXmlDocument() {
        return this.toXmlDocument("doc", null);
    }

    public Element toXmlDocument(String rootEltName, Object ns) {
        ArrayList orderedByStart = new ArrayList(this.extractedSpans);
        Collections.sort(orderedByStart, new Comparator(){

            public int compare(Object o, Object o1) {
                int start1 = ((Span)o).getStartIdx();
                int start2 = ((Span)o1).getStartIdx();
                return Double.compare(start1, start2);
            }
        });
        ArrayList roots = new ArrayList(orderedByStart);
        ObjectObjectHashMap children = new ObjectObjectHashMap();
        block0: for (int i = 0; i < orderedByStart.size(); ++i) {
            LabeledSpan child = (LabeledSpan)orderedByStart.get(i);
            for (int j = i - 1; j >= 0; --j) {
                LabeledSpan parent = (LabeledSpan)orderedByStart.get(j);
                if (!parent.isSubspan(child)) continue;
                ArrayList<LabeledSpan> childList = (ArrayList<LabeledSpan>)children.get(parent);
                if (childList == null) {
                    childList = new ArrayList<LabeledSpan>();
                    children.put(parent, childList);
                }
                roots.remove(child);
                childList.add(child);
                continue block0;
            }
        }
        CharSequence doc = (CharSequence)this.document;
        StringSpan wholeDoc = new StringSpan(doc, 0, doc.length());
        return this.generateElement(rootEltName, wholeDoc, roots, children);
    }

    private Element generateElement(String parentName, Span span, List childSpans, ObjectObjectHashMap tree) {
        Element parentElt = new Element(parentName);
        if (childSpans == null || childSpans.isEmpty()) {
            parentElt.setContent(new Text(span.getText()));
        } else {
            ArrayList<Element> childElts = new ArrayList<Element>(childSpans.size());
            int start = span.getStartIdx();
            int current = 0;
            for (int i = 0; i < childSpans.size(); ++i) {
                LabeledSpan childSpan = (LabeledSpan)childSpans.get(i);
                Label childLabel = childSpan.getLabel();
                int childStart = childSpan.getStartIdx() - start;
                if (childStart > current) {
                    childElts.add(new Text(span.getText().substring(current, childStart)));
                }
                if (childLabel == this.backgroundTag) {
                    childElts.add(new Text(childSpan.getText()));
                } else {
                    String name = childLabel.getEntry().toString();
                    List grandchildren = (List)tree.get(childSpan);
                    childElts.add(this.generateElement(name, childSpan, grandchildren, tree));
                }
                current = childSpan.getEndIdx() - start;
            }
            if (current < span.getEndIdx()) {
                childElts.add(new Text(span.getText().substring(current)));
            }
            parentElt.addContent(childElts);
        }
        return parentElt;
    }

    public String toXmlString() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + this.toXmlDocument().toString() + "\n";
    }

    public int size() {
        return this.extractedSpans.size();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.readInt();
    }
}

