/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import weka.gui.sql.ResultSetTableModel;

public class ResultSetTableCellRenderer
extends DefaultTableCellRenderer {
    private Color missingColor;
    private Color missingColorSelected;

    public ResultSetTableCellRenderer() {
        this(new Color(223, 223, 223), new Color(192, 192, 192));
    }

    public ResultSetTableCellRenderer(Color color, Color color2) {
        this.missingColor = color;
        this.missingColorSelected = color2;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (jTable.getModel() instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)jTable.getModel();
            if (n >= 0) {
                if (resultSetTableModel.isNullAt(n, n2)) {
                    this.setToolTipText("NULL");
                    if (bl) {
                        component.setBackground(this.missingColorSelected);
                    } else {
                        component.setBackground(this.missingColor);
                    }
                } else {
                    this.setToolTipText(null);
                    if (bl) {
                        component.setBackground(jTable.getSelectionBackground());
                    } else {
                        component.setBackground(Color.WHITE);
                    }
                }
                if (resultSetTableModel.isNumericAt(n2)) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.setHorizontalAlignment(0);
                if (jTable.getColumnModel().getSelectionModel().isSelectedIndex(n2)) {
                    component.setBackground(UIManager.getColor("TableHeader.background").darker());
                } else {
                    component.setBackground(UIManager.getColor("TableHeader.background"));
                }
            }
        }
        return component;
    }
}

